/*  Moe - My Own Editor
    Copyright (C) 2005 Antonio Diaz Diaz.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
*/

namespace Block {

Buffer & buffer() throw();
bool same_buffer( const Buffer & buffer ) throw();
Point & begin() throw();
Point & end() throw();

bool in_block( const Buffer & buffer, const Point & p ) throw();
bool in_block_or_end( const Buffer & buffer, const Point & p ) throw();
bool valid() throw();

void save_block_position() throw();
void restore_block_position() throw();
void reset() throw();
void set_block( Buffer & buffer, const Point & p1, const Point & p2 ) throw();
void set_begin( Buffer & buffer, const Point & p ) throw();
void set_end( Buffer & buffer, const Point & p ) throw();

bool follow_marking( const Buffer & buffer, const Point & p ) throw();
const char * toggle_marking( Buffer & buffer, const Point & p ) throw();

bool copy_block( Buffer & buffer, const Point & p ) throw();
bool delete_block() throw();
bool move_block( Buffer & buffer, const Point & p ) throw();

} // end namespace Block
