/*  Moe - My Own Editor
    Copyright (C) 2005 Antonio Diaz Diaz.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
*/

namespace RC {

struct Options
  {
  int keep_lines;
  bool auto_unmark, backup, /*beep,*/ exit_ask, ignore_case;
  bool orphan_extra, /*rectangle_mode,*/ smart_home, search_wrap;

  Options() throw()
    : keep_lines( -1 ),
    auto_unmark( false ), backup( true ), /*beep( false ),*/ exit_ask( false ),
    ignore_case( false ), orphan_extra( false ), /*rectangle_mode( false ),*/
    smart_home( true ), search_wrap( false ) {}

  void reset() throw() { *this = Options(); }
  };


Options & options() throw();		// Global editor options
const Buffer::Options & default_buffer_options() throw();

void apply_regex_options( Buffer & buffer ) throw();

bool parse_int( const std::string & s, int & result ) throw();

// Returns 0 for success, 1 for file not found, 2 for syntax error.
//
int process_rcfile( const std::string & name ) throw();

// Returns 0 for success, 1 for invalid option, 2 for a no regular file.
//
int process_options( int argc, char *argv[] ) throw();

void reset() throw();

// Defined in main.cc
//
const std::string & home_directory() throw();
void show_error( const char * msg, const int errcode = 0, const bool help = false ) throw();

} // end namespace RC
