/*  GNU Moe - My Own Editor
    Copyright (C) 2005 Antonio Diaz Diaz.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
*/

class Window
  {
  int _top_line, _height;	// top line and height of window on screen
  Buffer_handle *bhp;

public:
  static const int min_height = 4;
  Window( const int tl, const int h, Buffer_handle & bh, const bool center ) throw();

  Buffer & buffer() const throw() { return bhp->buffer(); }
  Buffer_handle & buffer_handle() const throw() { return *bhp; }

  Point clock_position() const throw();
  Point absolute_cursor() const throw();	// cursor position on screen
  Point relative_cursor() const throw();	// cursor position on window
  int height() const throw() { return _height; }
  int top_line() const throw() { return _top_line; }

  void center_cursor() throw();
  void goto_bof() throw();
  void goto_eof() throw();
  void goto_home() throw();
  void goto_eol() throw();
  void goto_begin_of_block() throw();
  void goto_end_of_block() throw();
  void goto_line() throw();
  void goto_column() throw();
  void goto_mark( const int i ) throw();
  void goto_matching_delimiter( const bool forward = true ) throw();
  void goto_pnext() throw();
  void goto_pprev() throw();
  void move_page( const bool down ) throw();
  void move_vertical( const int lines ) throw();
  void scroll_horizontal( const int cols ) throw();
  void scroll_page( const bool down ) throw();
  void scroll_vertical( const int lines ) throw();

  void set_mark( const int i ) throw();

  void repaint() const throw();
  void show_character_info() const throw();
  void show_status_line( const char * prefix = "" ) const throw();

  enum From { from_top_left, from_cursor, from_pointer };
  void update_points( const Point & to, const bool show = true,
                      bool center = false, const From from = from_pointer ) throw();
  };


class Window_vector
  {
  int _curwin;			// current window (the one with the cursor in)
  std::vector< Window > data;

public:
  Window_vector() throw() {}
  int init() throw();
  int load( int new_size = 0 ) throw();

  void load_file() throw();
  void split_window() throw();
  void save_file() const throw();
  void save_all_named() const throw();
  int close( bool abort, const bool quiet = false ) throw();
  int close_and_exit( const bool abort ) throw();

  Window & curwin() throw() { return data[_curwin]; }
  void next() throw();
  void prev() throw();
  Window & operator[]( int i ) throw();
  int windows() const throw() { return data.size(); }

  void add_char( unsigned char ch, const bool force = false ) throw();
  void delete_char( const bool back = false ) throw();
  void delete_line() throw();
  void delete_block() throw();
  void copy_block() throw();
  void move_block() throw();
  void read_block() throw();
  void write_block() const throw();
  void indent_block() throw();
  void unindent_block() throw();
  void undo() throw();
  void redo() throw();

  void center_line() throw();
  void reformat() throw();

  void toggle_marking() const throw();
  void repaint( const Buffer * bufp = 0 ) const throw();
  void show_status_lines( const Buffer * bufp = 0, const char * prefix = "" ) const throw();

  void search( const bool again = false ) throw();
  };
