/*  GNU Moe - My Own Editor
    Copyright (C) 2005, 2006 Antonio Diaz Diaz.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
*/

namespace ISO_8859 {

// 'seq' contains a escape sequence (the characters following a '\')
// Returns the corresponding code and, in *lenp, the characters read
// Returns -1 if error
//
int escape( const std::string & seq, int *lenp = 0 ) throw();


// Replace the escape sequences for special characters; "\n" --> '\n'
//
void deescapize( std::string & s ) throw();


// Replace tabs with tab escape sequences; '\t' --> "\t"
//
void detabize( std::string & s ) throw();


bool isalpha_( const unsigned char ch ) throw();
bool isalnum_( const unsigned char ch ) throw();
bool isblank( const unsigned char ch ) throw();
bool iscntrl( const unsigned char ch ) throw();
bool isodigit( const unsigned char ch ) throw();  // tests if 'ch' is a octal digit
bool isprint( const unsigned char ch ) throw();

const char * control_name( const unsigned char ch ) throw();  // '^A' --> "^A"
int controlize( int code ) throw();	// converts 'A' or 'a' into '^A'
int decontrolize( int code ) throw();	// converts '^A' or 'a' into 'A'
char tolower( const unsigned char ch ) throw();
char toupper( const unsigned char ch ) throw();
int xtoi( const unsigned char ch ) throw();	// returns value of hex digit 'ch'

} // end namespace ISO_8859
