/*  GNU Moe - My Own Editor
    Copyright (C) 2005, 2006 Antonio Diaz Diaz.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
*/

#include <string>
#include <vector>

#include "buffer.h"
#include "menu.h"
#include "screen.h"


namespace Menu_help {

const char *help_line[] = {
  "@i Help Screen: Keyboard Commands               PAGE_DN next         F1 exit help",
  " @bF1@b Help             @bF5@b Prev window     @bF9@b Copy block   ^C  Close window",
  " @bF2@b Save file        @bF6@b Next window    @bF10@b Options      ^X  Save and close",
  " @bF3@b Load file        @bF7@b Undo           @bF11@b Buffers      ^QX Save all and exit",
  " @bF4@b Zoom window      @bF8@b Redo           @bF12@b              ^QC Exit without saving",
  " ",
  " @bGO TO@b               @bBLOCK@b             @bSEARCH@b           @bMISC@b",
  " ^[U Beg of file     ^SPACE Mark       ^F Find          Ins Insert/Overwrite",
  " ^[V End of file     ^KB Begin         ^G Find next     Tab Filename completion",
  " ^[L Line            ^KK End                            ^B  Reformat paragraph",
  " ^[C Column          ^KC Copy          @bDELETE@b           ^P  Control char",
  " ^[B Beg of block    ^KM Move          ^Y Line          ^S  Show status",
  " ^[K End of block    ^KY Delete                         ^OC Center line",
  " ^[G Match pair ->   ^KR Read                           ^OR Repaint screen",
  " ^[H Match pair <-   ^KW Write                          ^OS Split window",
  " ^[D Center cursor   ^KI Indent                         ^OV Show version",
  "                     ^KU Unindent                       ^Q@bF2@b Save named buffers",
  " @bSCROLL@b",
  " ^[W Up",
  " ^[Z Down            @bBOOKMARKS@b",
  " ^[A Left            ^[ 0-9 Goto",
  " ^[S Right           ^K 0-9 Set",
  " ",
  " ^[X means Alt-X or Esc-X    ^X means Control-X",
  "",
  "@i Help Screen: Search/Replace                  PAGE_UP prev         F1 exit help",
  " Escape sequences for special characters:",
  "   \\a  BEL (alert)       \\n  LF (newline)           \\\\   '\\' (backslash)",
  "   \\b  BS  (backspace)   \\r  CR (carriage return)   \\ooo  octal code 'ooo'",
  "   \\e  ESC (escape)      \\t  HT (tab)               \\xhh  hexadecimal code 'hh'",
  "   \\f  FF  (form feed)   \\v  VT (vertical tab)",
  " ",
  " Special search sequences:",
  "   \\?      matches any single char       \\^  \\$  matches beginning/end of line",
  "   \\*      matches 0 or more chars       \\<  \\>  matches beginning/end of word",
  "   \\[..]   matches one in a set          \\c      matches balanced C expression",
  "   \\[^..]  matches one not in a set      \\+<ch>  matches 0 or more of <ch>",
  "   \\w      matches 0 or more whitespace characters",
  " Notes",
  "     Ranges of characters may be specified in sets with 'A-Z'",
  "     '-' may be specified in sets by placing it first or last",
  "     ']' may be specified in sets by placing it first",
  "     \\+\\[..] matches 0 or more chars of those in set",
  " ",
  " Special replace sequences:",
  "     \\&      replaced with text which matched search string",
  "     \\0 - 9  replaced with text which matched Nth \\?, \\*, \\[..], \\c, \\+ or \\w",
  0 };


class Help_index
  {
  std::vector< int > data;
public:
  Help_index()
    {
    data.push_back( 0 );
    for( int i = 0; ; ++i )
      {
      const char *p = help_line[i];
      if( !p || *p == 0 ) { data.push_back( i + 1 ); if( !p ) break; }
      }
    }
  int operator[]( int i ) const throw() { return data[i]; }
  int size() const throw() { return data.size(); }
  } help_index;


void show_help( int delta ) throw()
  {
  static int current = 0;

  if( delta > 0 && current + 2 < help_index.size() ) ++current;
  else if( delta < 0 && current > 0 ) --current;
  else if( delta != 0 ) return;

  int line = 0;
  for( int i = help_index[current]; i < help_index[current+1] - 1; ++i )
    {
    if( !help_line[i] ) break;
    Screen::out_line( help_line[i], line ); ++line;
    }
  while( line < Screen::height() ) { Screen::out_line( "", line ); ++line; }
  }

} // end namespace Menu_help


void Menu_help::help_menu( const int abort_key ) throw()
  {
  Screen::save_lines_and_cursor( 0, Screen::height() );

  int key = abort_key + 1, delta = 0;
  while( key != abort_key )
    {
    show_help( delta );
    Screen::move_to( Point( 0, Screen::width() - 1 ) );
    while( true )
      {
      key = Screen::wait_kbhit( 1 );		// show clock on line 0 only
      if( key == 3 ) key = abort_key;		// ^C
      if( key == abort_key ) break;
      if( Screen::convert_key( key ) == Screen::key_npage ) { delta = +1; break; }
      if( Screen::convert_key( key ) == Screen::key_ppage ) { delta = -1; break; }
      }
    }
  Screen::restore_lines_and_cursor();
  }
