/*  GNU Moe - My Own Editor
    Copyright (C) 2005, 2006, 2007 Antonio Diaz Diaz.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

namespace Regex {

// Searches 'buffer' from 'p1' ('p1-1' if backward) for 'regex'.
// If found, sets 'p1' at the first char of, and 'p2' after the
// found substring and returns in 'pieces' the text matching every \*,
// \? etc from the regular expresion.
//
bool find( const Buffer & buffer, Point & p1, Point & p2,
           const std::string & regex, std::vector< std::string > & pieces,
           bool icase = false, bool backward = false ) throw();


// Deletes block at [p1,p2) and replaces it with the text produced from
// 'regex' and 'pieces'.
// If there is no error, returns true and sets 'p2' after the newly
// inserted text.
//
bool replace( Buffer & buffer, const Point & p1, Point & p2,
              const std::string & regex,
              const std::vector< std::string > & pieces ) throw();


// returns true if 'name' matches 'regex'
//
bool match_filename( const std::string & regex, const std::string & name ) throw();

} // end namespace Regex
