/***************************************************************
 *                    simula+@metz.ensam.fr                    *
 *                   GNU/linux version 0.4.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright  2003,2004,2005,2006 COLLARD Christophe
 * copyright  2003,2004,2005 CREUSE Emmanuel
 * copyright  2003,2004,2005,2006 Laboratoire de Physique et Mcanique des Matriaux (LPMM - UMR 7554)
 * copyright  2003,2004,2005,2006 Laboratoire de Mathmatiques et ses Applications de Valenciennes (LAMAV - EA 4015)
 ***************************************************************/

/*
    tests-maths belongs to Mathematical Object Libraries (MOL++)
    MOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for the type interface.
#endif

#if !defined(__IOSTREAM_H)
#include <iostream>
#endif

#if !defined(__FSTREAM_H)
#include <fstream>
#endif

#if !defined(__STDIO_H)
#include <stdio.h>
#endif

#if !defined (__STDLIB_H)
#include <stdlib.h>
#endif

#if !defined(__TIME_H)
#include <time.h>
#endif

#if !defined(__MATHS_TEST_H)
#include "maths-test.h"
#endif

#if !defined(__VECTORS_TEST_H)
#include "vectors-test.h"
#endif

#if !defined (__MATRIX_TEST_H)
#include "matrix-test.h"
#endif

#if !defined(__SYMMATRIX_TEST_H)
#include "symmatrix-test.h"
#endif

#if !defined(__SPMATRIX_TEST_H)
#include "spmatrix-test.h"
#endif

//#if !defined(__BMATRIX_H)
//#include "bandwidthmatrix-linux.h"
//#endif

#if !defined(__LINEAR_SYSTEMS_TEST_H)
#include"linear systems-test.h"
#endif

#if !defined(__TENSORS2_TEST_H)
#include "tensors2-test.h"
#endif

#if !defined(__TENSORS3_TEST_H)
#include "tensors3-test.h"
#endif

#if !defined(__TENSORS4_TEST_H)
#include "tensors4-test.h"
#endif

#if !defined(__CONVERSION_TOOLS_TEST_H)
#include "conversion tools-test.h"
#endif

#if !defined(__POLYNOMS_TEST_H)
#include "polynoms-test.h"
#endif

#if !defined(__LEGENDRE_TEST_H)
#include "legendre-test.h"
#endif

#if !defined(__INTEGRATION_TEST_H)
#include "integration-test.h"
#endif

#if !defined(__COMBINATORIAL_ANALYSIS_TEST_H)
#include "combinatorial analysis-test.h"
#endif

/*#if !defined(__ODE_TEST_H)
#include "ode-test.h"
#endif
*/
using namespace std;

main()
{
  bool detail; // parameter to write/hide test procedure
  bool result = true;
  clock_t start, end;
  clock_t start_main, end_main;

  result = 1;

  detail = 0;
  start_main = start = clock();
  if (detail)
    //=======================================================================
    cout<< "---------------------------maths---------------------------- \n";
    //=======================================================================
  result *= test_maths(detail);
  end = clock();
  cout<<"cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout<< "---------------------------vector--------------------------- \n";
    //=======================================================================
  result *= test_vector(detail);
  end = clock();
  cout<<"cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout << "--------------------------matrix--------------------------- \n";
    //=======================================================================
  result *= test_matrix(detail);
  end = clock();
  cout<<"cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout << "---------------------symmetric matrix---------------------- \n";
    //=======================================================================
  result *= test_symmatrix(detail);
  end = clock();
  cout<<"cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 1;
  start = clock();
  if (detail)
    //=======================================================================
    cout << "-----------------------sparse matrix----------------------- \n";
    //=======================================================================
  result *= test_spmatrix(detail);
  end = clock();
  cout<<"cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout << "-----------------------linear systems---------------------- \n";
    //=======================================================================
  result *= test_linear_systems(detail);
  end = clock();
  cout<<"cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout << "---------------------2nd order tensors--------------------- \n";
    //=======================================================================
  result *= test_tensor2(detail);
  end = clock();
  cout<<"cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout << "---------------------3rd order tensors--------------------- \n";
    //=======================================================================
  result *= test_tensor3(detail);
  end = clock();
  cout<<"cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  if (detail)
    //=======================================================================
    cout << "---------------------4th order tensor---------------------- \n";
    //=======================================================================
  result *= test_tensor4(detail);
  end = clock();
  cout<<"cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout<< "----------------------conversion tools---------------------- \n";
    //=======================================================================
  result *= test_conversion_tools(detail);
  end = clock();
  cout<<"cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout<< "--------------------------polynom--------------------------- \n";
    //=======================================================================
  result *= test_polynom(detail);
  end = clock();
  cout<<"cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  /*
  detail = 1;
  start = clock();
  if (detail)
    //=======================================================================
    cout<< "------------------------function---------------------------- \n";
    //=======================================================================
  result *= test_function(detail);
  end = clock();
  cout<<"cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;
  */

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout<< "--------------------------Legendre-------------------------- \n";
    //=======================================================================
  result *= test_legendre(detail);
  end = clock();
  cout<<"cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout<< "-----------------------integration-------------------------- \n";
    //=======================================================================
  result *= test_integration(detail);
  end = clock();
  cout<<"cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout<< "-----------------combinatorial analysis--------------------- \n";
    //=======================================================================
  result *= test_combinatorial_analysis(detail);
  end = clock();
  cout<<"cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  /*
  detail = 1;
  start = clock();
  if (detail)
    //=======================================================================
    cout<< "-------------ordinary differential equations---------------- \n";
    //=======================================================================
  result *= test_ode(detail);
  end = clock();
  cout<<"cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  detail = 1;
  start = clock();
  if (detail)
    //=======================================================================
    cout<< "-------------ordinary differential equations 1D------------- \n";
    //=======================================================================
  result *= test_ode_1D(detail);
  end = clock();
  cout<<"cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 1;
  start = clock();
  if (detail)
    //=======================================================================
    cout<< "-------------ordinary differential equations 2D------------- \n";
    //=======================================================================
  result *= test_ode_2D(detail);
  end = clock();
  cout<<"cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;

  detail = 1;
  start = clock();
  if (detail)
    //=======================================================================
    cout<< "----------------non linear equations solving---------------- \n";
    //=======================================================================
  //  result *= test_NLE(detail);
  end = clock();
  cout<<"cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

  cout << endl;
  */

  cout << endl;

  end_main = clock();

  bool test = true;
  ifstream file("../simula+.log", ios::in);
  if (!file.fail())
    file >> test;
  file.close();
  test *= result;
  ofstream file2("../simula+.log", ios::out);
  assert (!file2.fail());
  file2 << test;
  file2.close();

  cout << "============================================================== \n";
  if (result) cout << "-------OK-------------end of MOL++ tests-------------OK------- \n";
  else cout << "-----FAILED-----------end of MOL++ tests-----------FAILED----- \n";
  cout << "============================================================== \n";

  cout<<"cpu time : " << (long double)(end_main-start_main)/CLOCKS_PER_SEC << endl;
}


