
/***************************************************************
 *                 Mathematical Object Library                 *
 *class symtensor2:declarations for 2nd order symmetric tensors*
 *                    simula+@metz.ensam.fr                    *
 *		     GNU/linux version 0.0.4                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright  2006 COLLARD Christophe
 * copyright  2006 Laboratoire de Physique et Mcanique des Matriaux (LPMM - UMR 7554)
 * copyright  2006 Laboratoire de Mathmatiques et ses Applications de Valenciennes (LAMAV - EA 4015)
 ***************************************************************/

/*! \class symtensor2
    \brief 2nd order symmetric tensor library \n

    \htmlonly 
    <FONT color="#838383">

    symtensor2 belongs to Mathematical Object Libraries (MOL++) </br>
    MOL++ is part of Simula+ <br><br>

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version. <br><br>

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details. <br><br>

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    </FONT>
    \endhtmlonly

    Let \f$ E \f$ be a Euclidean space of dimension \f$ n \f$ with basis vectors \f$ \{ e_i \} = (e_1,\ldots,e_n) \f$. A \f$ 2^\text{nd} \f$ order Euclidean tensor \f$ T \f$ is defined as a bilinear application from \f$ E \times E \longrightarrow \Bbb{R} \f$. We use a matrix storage for these tensors. All the basic operations are then already defined, so we just add some specific tensors operators to this class. \n

    \author copyright \htmlonly &#169; \endhtmlonly 2006 Christophe COLLARD \n
	    copyright \htmlonly &#169; \endhtmlonly 2006 Laboratoire de Physique et Mcanique des Matriaux (LPMM - UMR 7554) \n
	    copyright \htmlonly &#169; \endhtmlonly 2006 Laboratoire de Mathmatiques et ses Applications de Valenciennes (LAMAV - EA 4015)
    \version 0.0.4
    \date 2006
    \bug none
    \warning none
*/

#ifndef __cplusplus
#error Must use C++ for the type symtensor2
#endif

#if !defined(_SYMTENSORS2_H)
#define _SYMTENSORS2_H


#if !defined(__VECTORS_H)
#include "vectors.h"
#endif

#if !defined(__SYMMATRIX_H)
#include "symmatrix.h"
#endif

#if !defined(__TENSORS2_H)
#include "tensors2.h"
#endif

using namespace std;


//==========================================================================
template <class T> class symtensor2 : public symmatrix<T>, public tensor2<T>
//==========================================================================
{
  public :  
    symtensor2 () : symmatrix<T> () {}  // default constructor
    symtensor2 (int i, bool init=true, T value=0) : symmatrix<T> (i,i,init,value) {}         // this constructor allocates memory
    symtensor2 (int i, int j, bool init=true, T value=0) : symmatrix<T> (i,j,init,value) {}  // this constructor allocates memory
    symtensor2 (const symmatrix<T>& smat) : symmatrix<T> (smat) {}  // translation constructor (converts symmatrix -> symtensor2)
    symtensor2 (symtensor2<T>* st) : symmatrix<T>(st) {}            // copy constructor for temporary objects
    symtensor2 (symmatrix<T>* smat)  : symmatrix<T>(smat) {}        // copy constructor for temporary objects
    ~symtensor2 (){}        // destructor
};

//=====Private methods for symtensor2==========================================

//=====Public methods for symtensor2===========================================


#endif
