/***************************************************************
 *                    simula+@metz.ensam.fr                    *
 *                   GNU/linux version 1.1.8                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright  2003,2004,2005,2006 COLLARD Christophe
 * copyright  2003,2004,2005,2006 Laboratoire de Physique et Mcanique des Matriaux (LPMM - UMR 7554)
 * copyright  2003,2004,2005,2006 Laboratoire de Mathmatiques et ses Applications de Valenciennes (LAMAV - EA 4015)
 ***************************************************************/

/*
    polynoms-test belongs to Mathematical Object Libraries (MOL++)
    MOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for polynom-test
#endif

#if !defined(__POLYNOMS_TEST_H)
#define _polynoms_test_h


#if !defined(__IOSTREAM_H)
#include <iostream>
#endif

#if !defined(__STDIO_H)
#include <stdio.h>
#endif

#if !defined (__STDLIB_H)
#include <stdlib.h>
#endif

#if !defined(__VECTORS_H)
#include "../../MOL++/vectors.h"
#endif

#if !defined(__POLYNOMS_H)
#include "../../MOL++/polynoms.h"
#endif

#if !defined(__AFFICHE_h)
#include "../affiche.h"
#endif


//===========================
int test_polynom (int detail)
//===========================
{
  int result=1;
  polynom<long double> u(9), v(9), w(9), x, y, z(9), zz, yy(9), zal(9,true), zal2(9,false);
  polynom<long double> cst(7), cst1(7,false,5), cst2(7,true,2.5);

  for (int i=0; i<=7; i++)
    cst[i] = 2.5;

  // computes polynoms u, v and w
  u[0]=-7.2; u[1]=2.; u[2]=7.25; u[3]=14.670; u[4]=234.2; u[5]=0.; u[6]=0.543378; u[7]=13.; u[8]=0.; u[9]=45.;

  v[0]=2.5; v[1]=0.; v[2]=34.5; v[3]=70.00; v[4]=234.0; v[5]=111.; v[6]=233; v[7]=44.; v[8]=20.; v[9]=170.;

  w[0]=-4.7; w[1]=2.; w[2]=41.75; w[3]=84.670; w[4]=468.2; w[5]=111.; w[6]=233.543378; w[7]=57.; w[8]=20.; w[9]=215.;

  // starts tests

  if (detail) affiche ("dim()", u.dim()==1);
  else result *= (u.dim()==1);

  if (detail) affiche ("degree()", u.degree()==9);
  else result *= (u.degree()==9);

  bool test = true;
  int size = 0;
  if (u) size = u;
  else test = false;
  if (x) test = false;
  if (detail) affiche ("cast operator () polynom -> int", test && size==u.degree()+1);
  else result *= (test && size==u.degree()+1);

  if (detail) affiche ("operator !", !(!u) && !x);
  else result *= (!(!u) && !x);

  if (detail) affiche ("operator !=", (u!=v));
  else result *= (u!=v);

  if (detail) affiche ("operator ==", !(u==v) && z==zal);
  else result *= !(u==v) && z==zal;

  if (detail) affiche ("operator []", u[2]==7.25 && u[0]==-7.2);
  else result *= (u[2]==7.25 && u[0]==-7.2);

  x = u;
  if (detail) affiche ("operator !=", (!(u!=x)));
  else result *= (!(u!=x));

  if (detail) affiche ("operator ==", (u==x));
  else result *= (u==x);

  if (detail) affiche ("constructor", cst==cst2);
  else result *= cst==cst2;

  x[1] = 23;
  z[0]=-7.2; z[1]=2; z[2]=7.25; z[3]=14.67; z[4]=234.2; z[5]=0; z[6]=0.543378; z[7]=13; z[8]=0; z[9]=45;

  polynom<long double> ual, wal;
  ual.assign(9);
  ual[0]=-7.2; ual[1]=2.; ual[2]=7.25; ual[3]=14.67; ual[4]=234.2; ual[5]=0.; ual[6]=0.543378; ual[7]=13.; ual[8]=0.; ual[9]=45.;

  if (detail) affiche("assign", (ual==z));
  else result *= (ual==z);

  if (detail) affiche("operator =", (u==z));
  else result *= (u==z);

  wal=9;
  wal[0]=-7.2; wal[1]=2.; wal[2]=7.25; wal[3]=14.67; wal[4]=234.2; wal[5]=0.; wal[6]=0.543378; wal[7]=13.; wal[8]=0.; wal[9]=45.;
  if (detail) affiche("operator = (memory allocation)", (wal==z));
  else result *= (wal==z);

  polynom<double> veq1(9), veq2(9), veq3, veq4;
  veq1[0] = 1.456; veq2[0]=-3.45;
  for (int i=1; i<=9; i++)
    { veq1[i] = 2*i/3.;
      veq2[i] = 1/(1.*i);
    }
  veq3 = veq1 + veq2;
  veq4 = &(veq1+veq2);
  polynom<double> veq5 = &veq1;
  if (detail) affiche("operator = (destructive copy for temporary objects)", veq3==veq4 && veq5==veq3-veq2 && !veq1);
  else result *= (veq3==veq4 && veq5==veq3-veq2 && !veq1);

  polynom<long double> vdel(9), vnew(5), vcp, vcopy, vcpy, empty;
  vdel[0] = -1.234;
  for (int i=1; i<=9; i++)
    vdel[i] = i;
  vcpy = vcopy = vdel;
  vnew &= vcopy;
  vcp &= vcopy;
  vcpy &= empty;
  if (detail) affiche ("operateur &= (copy without size check)", vnew==vdel && vcp==vdel && vcopy==vdel && !vcpy && !empty);
  else result *= (vnew==vdel && vcp==vdel && vcopy==vdel && !vcpy && !empty);

  polynom<double> vop1(9), vop2(9), vop3, vop4;
  vop1[0] = -1.234; vop2[0]=0.234;
  for (int i=1; i<=9; i++)
    { vop1[i] = 2*i/3.;
      vop2[i] = 1/(1.*i);
    }
  vop3 = vop1 + vop2;
  vop4 &= &(vop1+vop2);
  polynom<double> vop5 = vop1;
  polynom<double> vop6, vop7, vop8, vop9(2);
  vop5 &=& vop7;
  vop6 &=& vop7;
  vop8 = vop3;
  vop9 &=& vop8;
  if (detail) affiche("operator &=& (detructive copy for temporary objects without size check)", vop3==vop4 && !vop5 && !vop6 && vop9==vop3 && !vop8);
  else result *= (vop3==vop4 && !vop5 && !vop6 && vop9==vop3 && !vop8);

  polynom<long double> Px(3), Qx=u;
  Px[0] = -2.125;  Px[1] = 0.456;  Px[2] = -0.345;  Px[3] = -2.752;
  for (int i=0; i<=3; i++)
    Qx[i] += Px[i];

  if (detail) affiche ("operator +", (w == u+v) && (u+Px == Qx) && (Px+u == Qx));
  else result *= (w == u+v) && (u+Px == Qx) && (Px+u == Qx);

  x[0]=-9.7; x[1]=2.; x[2]=-27.25; x[3]=-55.33; x[4]=0.2; x[5]=-111.; x[6]=-232.456622; x[7]=-31.; x[8]=-20.; x[9]=-125.;

  if (detail) affiche ("operator -", (x-u+v == yy) && (Qx-Px == u) && (Px-Qx == (long double) -1*u));
  else result *= (x-u+v == yy) && (Qx-Px == u) && (Px-Qx == (long double)-1*u);

  polynom<long double> Tx(2), Sx(11);
  Tx[2] = 1; Tx[0]=1;
  Sx[11]=45;  Sx[9]=58; Sx[8]=0.543378; Sx[7]=13; Sx[6]=234.743378; Sx[5]=14.67; Sx[4]=241.45; Sx[3]=16.67; Sx[2]=0.05; Sx[1]=2; Sx[0]=-7.2;
  if (detail) affiche("operator *", u*Tx==Sx && Tx*u==Sx);
  else result *= (u*Tx==Sx && Tx*u==Sx);

  polynom<long double> dv(0);
  dv[0] = 2;
  if (detail) affiche ("operator /", (long double) 2*(u/dv) == u);
  else result *= ( (long double) 2*(u/dv) == u);

  x=u;
  x+=v;
  polynom<long double> Rx = u;
  Rx += Px;
  if (detail) affiche("operator +=", x==u+v && Rx==Qx);
  else result *= (x==u+v && Rx==Qx);

  x=u;
  x-=u;
  Rx -= Px;
  if (detail) affiche("operator -=", x==yy && Rx==u);
  else result *= (x==yy && Rx==u);

  long double reel=2.;
  if (detail) affiche("operator * sc/vect", (reel*u==u+u));
  else result *= (reel*u==u+u);

  if (detail) affiche("operator * vect/sc", (u*reel==u+u));
  else result *= (u*reel==u+u);

  if (detail) affiche("operator / vect/sc", (u+u)/reel==u);
  else result *= ((u+u)/reel==u);

  x=u; x*=2.;
  if (detail) affiche("operator *=", (x==u+u));
  else result *= (x==u+u);

  x=u;
  x/=2.;
  z[0]=-3.6; z[1]=1.; z[2]=3.625; z[3]=7.335; z[4]=117.1; z[5]=0.; z[6]=0.271689; z[7]=6.5; z[8]=0.;z[9]=22.5;
  if (detail) affiche("operator /=", x==z);
  else result *=  (x==z);

  v=yy;
  v[0] = 2.345;
  v[1] = 4.43 ;
  v[2] = -1.234 ;
  v[5] = -12.34 ;
  v.save("polynom.res");
  polynom<long double> fvect(9);
  fvect.read("polynom.res");
  if (detail) affiche("read/write", v==fvect);
  else result *= (v==fvect);

  polynom<long double> zpermute = z;
  zpermute.permute(5,7);
  zpermute.permute(9,0);
  long double element = z[5];
  z[5] = z[7];
  z[7] = element;
  element = z[9];
  z[9] = z[0];
  z[0] = element;
  if (detail) affiche("permutation of 2 coefficients", z==zpermute);
  else result *= (z==zpermute);

  polynom<long double> upermute = u;
  permute (zpermute,upermute);
  if (detail) affiche("polynom permutation (u_i <-> v_i)", u==zpermute && z==upermute);
  else result *= (u==zpermute && z==upermute);

  polynom<long double> vv(3),vv1(3);
  vv[0]=-2.1; vv[1]=1.02;vv[2]=-1.05;vv[3]=-4.5555;
  vv1[0]=2.1; vv1[1]=1.02;vv1[2]=1.05;vv1[3]=4.5555;
  if (detail) affiche("abs", abs(vv)==vv1);
  else result *= (abs(vv)==vv1);

  polynom<long double> Zx(4);
  Zx[4]=1; Zx[2]=-7; Zx[1]=6;
  vector<long double> vnx(1);
  vnx[1] = reel = -2.34;
  if (detail) affiche("operator ()", Zx(0)==0 && Zx(1)==0 && Zx(2)==0 && Zx(-3)==0 && Zx(-1)==-12 && Zx(vnx)[1]==Zx(reel));
  else result *= (Zx(0)==0 && Zx(1)==0 && Zx(2)==0 && Zx(-3)==0 && Zx(-1)==-12 && Zx(vnx)[1]==Zx(reel));

  polynom<long double> Wx(3), Yx(2), Ux(0), Vx(0);
  Wx[3]=4; Wx[1]=-14; Wx[0]=6;
  Yx[2]=12; Yx[0]=-14;
  Vx[0] = 24;
  if (detail) affiche("D_dx", Zx.D_dx()==Wx && Zx.D_dx(2)==Yx && Zx.D_dx(4)==Vx && Zx.D_dx(5)==Ux && Zx.D_dx(125)==Ux);
  else result *= (Zx.D_dx()==Wx && Zx.D_dx(2)==Yx && Zx.D_dx(4)==Vx && Zx.D_dx(5)==Ux && Zx.D_dx(125)==Ux);

  if (detail) affiche("d_dx", Zx.d_dx(0)==Wx(0) && Zx.d_dx(1)==Wx(1) && Zx.d_dx(-1)==Wx(-1) && Zx.d_dx(vnx)[1]==Zx.d_dx(reel));
  else result *= (Zx.d_dx(0)==Wx(0) && Zx.d_dx(1)==Wx(1) && Zx.d_dx(-1)==Wx(-1) && Zx.d_dx(vnx)[1]==Zx.d_dx(reel));

  if (detail) affiche("dn_dx", Zx.dn_dx(2,1)==Yx(1) && Zx.dn_dx(4,0)==Vx(0) && Zx.dn_dx(4,vnx)[1]==Vx(reel));
  else result *= (Zx.dn_dx(2,1)==Yx(1) && Zx.dn_dx(4,0)==Vx(0) && Zx.dn_dx(4,vnx)[1]==Vx(reel));

  cout << endl;  

  cout << "============================================================== \n";
  if (result) cout<< "                     polynom test passed \n";
  else cout << "                     polynom test failed \n";
  cout << "============================================================== \n";

  return result;
}


#endif
