/***************************************************************
 *                    simula+@metz.ensam.fr                    *
 *                   GNU/linux version 0.2.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright  2004,2005,2006,2007 COLLARD Christophe
 * copyright  2004,2005,2006,2007 Laboratoire de Physique et Mcanique des Matriaux (LPMM - UMR 7554)
 * copyright  2004,2005,2006,2007 Laboratoire de Mathmatiques et ses Applications de Valenciennes (LAMAV - EA 4015)
 ***************************************************************/

/*
    integration-test belongs to Mathematical Object Libraries (MOL++)
    MOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for the type integration-test.
#endif

#if !defined(__INTEGRATION_TEST_H)
#define _integration_test_h


#if !defined(__STDIO_H)
#include <stdio.h>
#endif

#if !defined(__VECTORS_H)
#include "MOL++/vectors.h"
#endif

#if !defined(__FUNCTIONS_H)
#include "MOL++/functions.h"
#endif

#if !defined(__POLYNOMS_H)
#include "MOL++/polynoms.h"
#endif

#if !defined(__INTEGRATION_H)
#include "MOL++/integration.h"
#endif

#if !defined(__AFFICHE_H)
#include "tests/affiche.h"
#endif


//===============================
int test_integration (int detail)
//===============================
{
  int result=1;

  integration<long double> I, I2;
  I.Gauss(10,-1,1);
  I2.Gauss(9,1,3);

  vector<long double> pts(10), wgts(10);
  pts.read("data/gauss10points.dat");
  wgts.read("data/gauss10weights.dat");

  vector<long double> pts2(9), wgts2(9);
  pts2.read("data/gauss9points.dat");
  wgts2.read("data/gauss9weights.dat");

  if (detail) affiche ("points()", pts==I.points() && pts2==I2.points());
  else result *= (pts==I.points() && pts2==I2.points());

  if (detail) affiche ("point(int)",abs(pts[2]-I.point(2))<epsilon && abs(pts2[2]-I2.point(2))<epsilon);
  else result *= (abs(pts[2]-I.point(2))<epsilon && abs(pts2[2]-I2.point(2))<epsilon);

  if (detail) affiche ("weights()", wgts==I.weights() && wgts2==I2.weights());
  else result *= (wgts==I.weights() && wgts2==I2.weights());

  if (detail) affiche ("weights(int)", abs(wgts[2]-I.weight(2))<epsilon && abs(wgts2[2]-I2.weight(2))<epsilon);
  else result *= (abs(wgts[2]-I.weight(2))<epsilon && abs(wgts2[2]-I2.weight(2))<epsilon);

  /*

// function P(x) = x^2 => I=9
  polynom<long double> Px (2);
  Px[2] = 1;
  vector<long double> xa(1), xb(1);
  xb[1] = 3;
  vector<int> n(1,true,1);
  long double Ip = auto_integrate(Px,xa,xb,n);
  if (detail) affiche ("polynom integration", abs(Ip-9.)<1.e-15);
  else result *= (abs(Ip-9.)<1.e-15);

//---------------------------------------------------------------------------------------------------

// function f(x) = x^2 => I=9
  function<long double> f(1,1);
  vector<long double> ao(1), bo(1);
  vector<int> no(1);
  bo[1] = 3; no[1]=1;
  f[1] = "x";
  Ip = auto_integrate(f,ao,bo,no);
  if (detail) affiche ("integration for R->R functions", abs(Ip-9.)<1.e-15);
  else result *= (abs(Ip-9.)<1.e-15);

  // function f(x) = x^2 / y => I=6.2383246
  function<long double> g(2,1);
  g[1] = "x/y";
  vector<long double> a(2), b(2);
  // x : 0->3 and y : 1->2
  b[1] = 3;
  b[2] = 2;
  a[2] = 1;
  Ip = auto_integrate (g,a,b);
  bool test = abs(Ip-9.*log(2.))<5e-15;

// function f(x) = x * exp (x*y) => I=198.2144
  function<long double> h(2,1);
  h[1] = "x*exp(x*y)";
  vector<long double> c(2), d(2);
  d[1] = 3;
  d[2] = 2;
  vector<int> ni(2,true,2);
  Ip = auto_integrate (h,c,d,ni);
  test *= abs(Ip - (exp(6.) - 7.) / 2.) < 7e-15;

  if (detail) affiche ("integration for R2->R functions", test); // modifier donner la valeur en fract. ration.
  else result *= (test);

// function = x^2 / y * sin(z) => I=1.827163
  function <long double> i(3,1);
  i[1] = "x/y*sin(z)";
  vector<long double> an(3), bn(3);
  // vector<int> nn(3,true,1);
  bn[1] = 3;
  an[2] = 1;
  bn[2] = 2;
  bn[3] = pi()/4;
  Ip = auto_integrate (i,an,bn);
  test = abs(Ip - 9. * log(2.) * (1 - sqrt(2.)/2.)) < 2e-15;

// function = x^2 z^2 exp(yz) => I=57.501505
  function<long double> j(3,1);
  j[1] = "x*z*exp(yz)";
  vector<long double> ai(3), bi(3);
  vector<int> nj(3);
  nj[1] = 7; nj[2] = 5; nj[3] = 9;
  bi[1] = 3;
  bi[2] = 1;
  bi[3] = 2;
  Ip = auto_integrate (j,ai,bi,nj);
  test *= abs(Ip - 9*(exp(2.)-1)) < 1.1e-15;

  if (detail) affiche ("integration for R3->R functions", test); // modifier donner la valeur en fract. ration.
  else result *= (test);
  */

  cout << endl;

  cout << "============================================================== \n";
  if (result) cout<< "               integration test passed \n";
  else cout << "               integration test failed \n";
  cout << "============================================================== \n";

  return result;
}


#endif
