/***************************************************************
 *                 Mathematical Object Library                 *
 *                    simula.plus@cemes.fr                     *
 *                   GNU/linux version 3.0.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright © 2002,2005,2006,2007,2008,2009,2012 COLLARD Christophe
 * copyright © 2002,2005,2006,2007,2008,2009,2012 Centre National de la Recherche Scientifique
 * copyright © 2002,2005,2006,2007,2008,2009 Arts et Métiers ParisTech
 * copyright © 2002,2005,2006,2007 Université de Valenciennes et du Hainaut Cambrésis
 * copyright © 2002,2005,2006,2007,2008,2009 Laboratoire de Physique et Mécanique des Matériaux (LPMM - CNRS)
 * copyright © 2002,2005,2006,2007 Laboratoire de Mathématiques et ses Applications de Valenciennes (LAMAV)
 * copyright © 2012 Centre d'Elaboration de Matériaux et d'Etudes Structurales (CEMES - CNRS)
 ***************************************************************/

/*! \namespace mol
    \brief Mathematical Object Libraries
*/

/*!
    \brief mathematical tools library \n

    \htmlonly 
    <FONT color="#838383">

    This library belongs to Mathematical Object Libraries (MOL++) </br>
    MOL++ is part of Simula+ <br><br>

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version. <br><br>

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details. <br><br>

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    </FONT>
    \endhtmlonly

    \author copyright \htmlonly &#169; \endhtmlonly 2002, 2005, 2006, 2007, 2008, 2009, 2012 Christophe COLLARD \n
            copyright \htmlonly &#169; 2002, 2005, 2006, 2007, 2008, 2009, 2012 Centre National de la Recherche Scientifique \endhtmlonly \n
	    copyright \htmlonly &#169; 2002, 2005, 2006, 2007, 2008, 2009 Arts et M&#233;tiers ParisTech \endhtmlonly \n
	    copyright \htmlonly &#169; 2002, 2005, 2006, 2007 Universit&#233; de Valenciennes et du Hainaut Cambr&#233;sis \endhtmlonly \n
	    copyright \htmlonly &#169; 2002, 2005, 2006, 2007, 2008, 2009 Laboratoire de Physique et M&#233;canique des Mat&#233;riaux (LPMM - CNRS) \endhtmlonly \n
	    copyright \htmlonly &#169; 2002, 2005, 2006, 2007 Laboratoire de Math&#233;matiques et ses Applications de Valenciennes (LAMAV) \endhtmlonly \n
	    copyright \htmlonly &#169; 2012 Centre d'Elaboration de Mat&#233;riaux et d'Etudes Structurales (CEMES - CNRS) \endhtmlonly \n
    \version 3.0.0
    \date 2002-2012
    \bug none
    \warning none
*/

#ifndef __cplusplus
#error Must use C++ for the type maths
#endif

#ifndef __maths_hpp
#define __maths_hpp


#ifndef __assert_h
#include <assert.h>
#endif

#ifndef __parameters_h
#include "parameters.h"
#endif

#ifndef __math_h
#include <math.h>
#endif

using namespace std;

namespace mol
{


//-------------------------------
template <typename T> T abs (T x)
//-------------------------------
{
  if (x < (T) 0) return -x;
  else return x;
}


//-------------------------------------------
template <class T> T power (const T& x,int n)
//-------------------------------------------
{
  T value = 1;
  for (int i=1; i<=n; i++)
    value *= x;
  return value;
}
  

//------------------------------
template <class T> int sgn (T x)
//------------------------------
{ int sign = 1;
  if (x < 0) sign = -1;
  return sign;
}


//---------------------------------
template <class T> T sup (T a, T b)
//---------------------------------
{
  return (a>b) ? a : b;
}


//---------------------------------
template <class T> T inf (T a, T b)
//---------------------------------
{
  return (a<b) ? a : b;
}


//---------------
long double pi ()
//---------------
{ return 3.14159265358979323846264338327950288419716939937510;
}


//----------------------------------
long double factorial (const int& n)
//----------------------------------
{
  if (n>2) return n*(factorial(n-1));
  else return n;
}


//---------------------------------------------
template <class T> int inv_factorial (T number)
//---------------------------------------------
{
  assert (number >0);
  int i;

  for (i=0; number>1;)
    number /= ++i;
  if (abs(number-1)>epsilon) i=-1; // error !

  return i;
}


//-----------------------------------------------------------------------------
template <typename T> bool relative_error (T a, T b, long double eps = epsilon)
//-----------------------------------------------------------------------------
{
  bool test;

  if (abs (a) < eps) test = abs (a - b) < eps;
  else test = abs ((a-b)/a) < eps;

  return test;
}


}


#endif
