/***************************************************************
 *                    simula.plus@cemes.fr                     *
 *	             GNU/linux version 3.4.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright © 2006,2007,2008,2009,2012 COLLARD Christophe
 * copyright © 2006,2007,2008,2009,2012 Centre National de la Recherche Scientifique
 * copyright © 2006,2007,2008,2009 Arts et Métiers ParisTech
 * copyright © 2006,2007 Université de Valenciennes et du Hainaut-Cambrésis
 * copyright © 2006,2007,2008,2009 Laboratoire de Physique et Mécanique des Matériaux (LPMM - CNRS)
 * copyright © 2006,2007 Laboratoire de Mathématiques et ses Applications de Valenciennes (LAMAV)
 * copyright © 2012 Centre d'Elaboration de Matériaux et d'Etudes Structurales (CEMES - CNRS)
 ***************************************************************/

/*
    symtensors2-test belongs to Mathematical Object Libraries (MOL++)
    MOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for symtensors2-test
#endif

#ifndef __symtensors2_test_hpp
#define __symtensors2_test_hpp


#ifndef __iostream
#include <iostream>
#endif

#ifndef __stdio_h
#include <stdio.h>
#endif

#ifndef __stdlib_h
#include <stdlib.h>
#endif

#ifndef __colors_hpp
#include "colors.hpp"
#endif

#ifndef __vectors_hpp
#include "MOL++/vectors.hpp"
#endif

#ifndef __matrix_hpp
#include "MOL++/matrix.hpp"
#endif

#ifndef __symtensors2_hpp
#include "MOL++/symtensors2.hpp"
#endif

#ifndef __affiche_hpp
#include "tests/affiche.hpp"
#endif

using namespace mol;

//==============================
int test_symtensor2 (int detail)
//==============================
{
  bool result = true;
  vector<long double> u(9), v(9), w(9);

  long double reel=2.;
  vector<long double> b(9);

  v[1] = 4 ;
  v[2] = -1 ;
  v[4] = -7;
  v[5] = -1 ;
  v[7] = 2;
  v[8] = 12;
  v[9] = 1.25;

  symtensor2<long double> a(9,9) , c, d, e(9,9), f(9,9), g(9,9), h(9,9), Id(9,9);
  matrix<long double> mat(9,9);
  tensor2<long double> tsr(9);

  if (detail) affiche ("operator !", !(!a) && !c);
  else result *= (!(!a) && !c);

  for (int i=1; i<=9; i++)
    for (int j=1; j<=i; j++)
      { a(i,j) = a(j,i) = 3*i/(2.*j) - 2*i*j;
	g(i,j) = 2*i/(1.*j);
	mat(i,j) = mat(j,i) = a(i,j);
	tsr(i,j) = tsr(j,i) = a(i,j);
      }

  for (int i=1; i<=9; i++)
    for (int j=1; j<=i; j++)
      e(i,j) = a(i,j);

  v[1]=-5; v[2]=24; v[3]=18; v[4]=27; v[5]=-13; v[6]=-1; v[7]=-11; v[8]=-10; v[9]=4;

  for (int i=1; i<=9; i++) Id(i,i)=1;

  if (detail) affiche ("operator ==", a==a && (a==e) && !(a==g));
  else result *= (a==a && (a==e) && !(a==g));

  symtensor2<long double> mtc(7,7), mtc2(7,7,true,-4.32), mtc3(7), mtc4(7,true,-4.32);
  for (int i=1; i<=7; i++)
    for (int j=1; j<=7; j++)
      mtc(i,j) = mtc3(i,j) = -4.32;
  if (detail) affiche ("constructor", mtc==mtc2 && mtc==mtc3 && mtc==mtc4 && mtc[1].dim()==1);
  else result *= mtc==mtc2 && mtc==mtc3 && mtc==mtc4 && mtc[1].dim()==1;

  if (detail) affiche ("cast constructor matrix -> symtensor2", (symtensor2<long double>) mat == a);
  else result *= ((symtensor2<long double>) mat == a);

  symmatrix<long double> symmat = mat;
  if (detail) affiche ("cast constructor symmatrix -> symtensor2", (symtensor2<long double>) symmat == a);
  else result *= ((symtensor2<long double>) symmat == a);

  if (detail) affiche ("cast constructor tensor2 -> symtensor2", (symtensor2<long double>) tsr == a);
  else result *= ((symtensor2<long double>) tsr == a);

  if (detail) affiche ("operator !=", !(a!=e) && a!=g);
  else result *= !(a!=e) && a!=g;

  d=a; g=a;
  if (detail) affiche ("operator =", a==d && g==a && g[1].dim()==1);
  else result *= (a==d && g==a && g[1].dim()==1);

  symtensor2<long double> mtx(7,7), mtx2, mtx3(7,7), mtx4(7,7);
  for (int i=1; i<=7; i++)
    for (int j=1; j<=i; j++)
      { mtx(i,j) = 2*i+5*j;
        mtx3(i,j) = i/(1.*j);
      }
  mtx2 = &(mtx3 + mtx);
  mtx4 = &(mtx3 + mtx);
  symtensor2<long double> mtx5 = &(mtx+mtx3);
  if (detail) affiche ("operator = (destructive copy for temporary objects)", mtx2==mtx3+mtx && mtx4==mtx3+mtx && mtx5==mtx+mtx3 && mtx2[1].dim()==1);
  else result *= (mtx2==mtx3+mtx && mtx4==mtx3+mtx && mtx5==mtx+mtx3 && mtx2[1].dim()==1);

  symtensor2<long double> mtrx, mtrx2(2,2), mtrx3(12,12), mtrx4, mtrx5, mtrx6, mtrx7, mtrx8;
  mtrx = mtrx8 = mtx;
  mtrx2 &= mtrx;
  mtrx3 &= mtrx4;
  mtrx7 &= mtrx8;
  if (detail) affiche ("operator &= (copy without size check)", mtrx2==mtx && mtrx.dim1() && !mtrx3 && mtrx7==mtx);
  else result *= (mtrx2==mtx && mtrx.dim1() && !mtrx3 && mtrx7==mtx);

  symtensor2<long double> mtrx9;
  mtrx = mtrx8 = mtx;
  mtrx2 &=& mtrx;
  mtrx3 &=& (mtx+mtx);
  mtrx4 &=& mtrx;
  mtrx5  &=& mtrx6;
  mtrx9 &=& mtrx8;
  if (detail) affiche ("operator &= (destructive copy for temporary objects with no size check)", mtrx2==mtx && !mtrx && mtrx3==(long double) 2*mtx && !mtrx4 && !mtrx5 && mtrx9==mtx && !mtrx8 && mtrx2[1].dim()==1);
  else result *= (mtrx2==mtx && !mtrx && mtrx3==(long double) 2*mtx && !mtrx4 && !mtrx5 && mtrx9==mtx && !mtrx8 && mtrx2[1].dim()==1);

  d=a;
  d(9,9)=7;
  reel = d(9,9);
  if (detail) affiche ("operator (,)", a!=d && reel==7);
  else result *= a!=d && reel==7;

  if (detail) affiche ("dim1 dim2", a.dim1()==9 && a.dim2()==9);
  else result *= a.dim1()==9 && a.dim2()==9;

  symtensor2<long double> mc01(5,5);
  vector<long double> vmc01(3);
  for (int i=1; i<=5; i++)
    for (int j=1; j<=3; j++)
      { mc01(i,j) = 7*i -5*j;
	vmc01[j] = 21 - 5*j;
      }
  mc01[3] = vmc01;
  if (detail) affiche ("operator []", (mc01[3] == vmc01) && (mc01[3][2]==vmc01[2]) && (mc01(3,2)==vmc01[2]));
  else result *= (mc01[3] == vmc01) && (mc01[3][2]==vmc01[2]) && (mc01(3,2)==vmc01[2]);

  for (int i=1; i<=9; i++)
    e[i] = (long double) 2 * a[i];
  if (detail) affiche ("operator +", a+a==e && (a+a)[1].dim()==1);
  else result *= (a+a==e && (a+a)[1].dim()==1);

  if (detail) affiche ("operator -", a-a==f && (a-a)[1].dim()==1);
  else result *= (a-a==f && (a-a)[1].dim()==1);

  for (int i=1; i<=9; i++)
    for (int j=1; j<=i; j++)
      g(i,j) = 2*i/(1.*j);
  tensor2<long double> ncb(9,9);
  for (int i=1; i<=9; i++)
    for (int j=1; j<=9; j++)
      { ncb(i,j) = 0;
        for (int k=1; k<=9; k++)
	  ncb(i,j) += a(i,k)*g(k,j);
      }
  if (detail) affiche ("operator *", a*g==ncb);
  else result *= (a*g==ncb);

  if (detail) affiche ("operator * symtensor2/sc", a*(long double)2== a+a && (a*(long double)2)[1].dim()==1);
  else result *= (a*(long double)2==a+a && (a*(long double)2)[1].dim()==1);

  if (detail) affiche ("operator * sc/symtensor2", (long double)2*a==a+a && ((long double)2*a)[1].dim()==1);
 else result *= ((long double)2*a==a+a && ((long double)2*a)[1].dim()==1);

  u[1]=u[9]=1.; u[2]=-2; u[3]=7; u[4]=5; u[5]=17; u[7]=-1; u[8]=0.; u[6]=2.;
  for (int i=1; i<=9; i++)
    { v[i] = 0;
      for (int j=1; j<=9; j++)
	v[i] += a(i,j) * u[j];
    }
  if (detail) affiche ("operator * symtensor2/vector", a*u==v);
  else result *= (a*u==v);

  w[1]=-5; w[2]=24; w[3]=18; w[4]=27; w[5]=-13; w[6]=-1; w[7]=-11; w[8]=-10; w[9]=4;    
  for (int i=1; i<=9; i++)
    { w[i]  = 0;
      for (int j=1; j<=9; j++)
	  w[i] += a(j,i) * u[j];
    }
  if (detail) affiche ("operator * vector/symtensor2", u*a==w);
  else result *= (u*a==w);

  symtensor2<long double> matdiv(9,9);
  for (int i=1; i<=9; i++)
    for (int j=1; j<=9; j++)
      matdiv(i,j) = 2*i +2.5*j - 1 + i/j;

  if (detail) affiche ("operator / ", matdiv/matdiv==Id && a/a==a*((long double)1/a));
  else result *= (matdiv/matdiv==Id && a/g==a*((long double)1/g));

  if (detail) affiche ("operator / symtensor2/scalar", a/reel==a*(1/reel) && (a/reel)[1].dim()==1);
  else result *= (a/reel==a*(1/reel) && (a/reel)[1].dim()==1);

  if (detail) affiche ("operator / scalar/symtensor2", ((long double)7.5/a)*a==(long double)7.5*Id && ((long double)7.5/a)[1].dim()==1);
  else result *= (((long double)7.5/a)*a==(long double)7.5*Id && ((long double)7.5/a)[1].dim()==1);

  long double sum=0;
  for (int i=1; i<=a.Rows(); i++)
    for (int j=1; j<=a.Columns(); j++)
      sum += a(i,j) * e(i,j);
  if (detail) affiche ("operator |", (a|e)==sum);
  else result *= ((a|e)==sum);

  if (detail) affiche ("operator ||", (a||e)==sum);
  else result *= ((a||e)==sum);

  symtensor2<float> mvv(7,7);
  vector<float> vctv(7);
  vctv[1]=1; vctv[2]=5; vctv[3]=7; vctv[4]=10; vctv[5]=-2; vctv[6]=3; vctv[7]=21;
  for (int i=1; i<=7; i++)
    for (int j=1; j<=7; j++)
      mvv(i,j) = vctv[i] * vctv[j];
  if (detail) affiche ("operator ^", mvv==(vctv^vctv));
  else result *= (mvv==(vctv^vctv));

  f=a; f+=a;
  if (detail) affiche ("operator +=", f==(long double)2*a && f[1].dim()==1);
  else result *= (f==(long double)2*a && f[1].dim()==1);

  f=a; f-=a;
  if (detail) affiche ("operator -=", f==h && f[1].dim()==1);
  else result *= (f==h && f[1].dim()==1);

  f=a; f*=2.;
  if (detail) affiche ("operator *= symtensor2/scalar", f==a+a && f[1].dim()==1);
  else result *= (f==a+a && f[1].dim()==1);

  symtensor2<long double> atest;
  atest = a;
  atest /= 4.76;
  if (detail) affiche ("operator /= symtensor2/scalar", atest==a/(long double) 4.76 && atest[1].dim()==1);
  else result *= (atest==a/(long double)4.76 && atest[1].dim()==1);

  matrix<long double> Ma;
  Ma = a;
  if (detail) affiche ("det", det(a) == det(Ma));
  else result *= (det(a) == det(Ma));

  if (detail) affiche ("t", t(a)==a && t(a)[1].dim()==1);
  else result *= (t(a)==a && t(a)[1].dim()==1);

  if (detail) affiche ("inv", a.inv()*a==Id);
  else result *= (a.inv()*a==Id);

  if (detail) affiche ("gauss", a*gauss(a) == Id && gauss(a)[1].dim()==1);
  else result *= (a*gauss(a) == Id && gauss(a)[1].dim()==1);

  symtensor2<long double> Ids(5);
  for (int i=1; i<=5; i++)
    Ids (i,i) = 1;
  if (detail) affiche("Id2s", Ids == Id2s<long double>(5) && Id2s<long double>(5)[1].dim()==1);
  else result *= (Ids == Id2s<long double>(5) && Id2s<long double>(5)[1].dim()==1);

  mtx.save("symtensor2.res");
  symtensor2<long double> ft(mtx.Rows(), mtx.Columns());
  ft.read("symtensor2.res");
  if (detail) affiche("read/write", mtx==ft);
  else result *= (mtx==ft);

  string filename = "stensor2.res";
  mtx.save(filename);
  symtensor2<long double> ft2(mtx.Rows(), mtx.Columns());
  ft2.read(filename);
  if (detail) affiche("read/write with a string argument", mtx==ft2);
  else result *= (mtx==ft2);

  symtensor2<long double> defmat1, defmat2, defmat4;
  symtensor2<long double> defmat3(5);
  defmat1.assign(5,5);
  for (int i=1; i<=5; i++)
    for (int j=1; j<=5; j++)
      defmat1(i,j) = defmat3(i,j) = i+2*j;
  if (detail) affiche("assign", defmat1==defmat3 && defmat1[1].dim()==1);
  else result *= (defmat1==defmat3 && defmat1[1].dim()==1);

  defmat4.create(5,5);
  for (int i=1; i<=5; i++)
    defmat4[i] = defmat3[i];
  if (detail) affiche ("create", defmat4==defmat3 && defmat4[1].dim()==1);
  else result *= (defmat4==defmat3 && defmat4[1].dim()==1);

  if (detail) affiche("tr", tr(g)==18);
  else result *= (tr(g)==18);

  if (detail) affiche("max", max(g)==18);
  else result *= (max(g)==18);

  vector<long double> diag(9,true,2);
  if (detail) affiche("diagonal", diagonal(g)==diag);
  else result *= (diagonal(g)==diag);

  symtensor2<long double> tx(3,3);
  tx(1,1) = 4; tx(1,2) = tx(1,3) = 2;
  tx(2,1) = 4; tx(2,2) = 6; tx(2,3) = 8;
  tx(3,1) = -2; tx(3,2) = 2; tx(3,3) = 4;
  symtensor2<long double> spherical(3,3), sphg(9,9);
  spherical(1,1) = spherical(2,2) = spherical(3,3) = tr(tx)/(long double)3;
  for (int i=1; i<=9; i++) sphg(i,i) = tr(g)/9;
  if (detail) affiche("sph", sph(tx)==spherical && sph(g)==sphg);
  else result *= (sph(tx)==spherical && sph(g)==sphg);

  symtensor2<long double> deviatoric =& (tx-spherical);
  symtensor2<long double> devg =& (g - sphg);
  if (detail) affiche("dev", dev(tx)==deviatoric && abs(tr(deviatoric))<epsilon && dev(g)==devg && abs(tr(devg))<epsilon);
  else result *= (dev(tx)==deviatoric && abs(tr(deviatoric))<epsilon && dev(g)==dev(g) && abs(tr(devg))<epsilon);

  cout << endl;

  cout << "============================================================== \n";
  if (result) cout << green << "            2nd order symmetric tensor test passed" << reset;
  else cout << red << "            2nd order symmetric tensor test failed" << reset;
  cout << "============================================================== \n";

  return result;
  
}


#endif
