// Copyright (C) 2011 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#include <config.h>
#include "tray-icon.h"
#include "main.h"

TrayIcon::TrayIcon()
        : menu_check("Are we there yet?")
{
  icon = Gtk::StatusIcon::create(Gdk::Pixbuf::create_from_file (Main::get_data_path() + "/data/mouse-graph.png"));
  icon->signal_activate().connect(sigc::mem_fun(*this, &TrayIcon::toggle_mouse_graphing));
  menu_check.set_sensitive(false);
  menu.append(menu_check);
  menu_check.signal_activate().connect(sigc::mem_fun(*this, &TrayIcon::on_show_graph));
  Gtk::ImageMenuItem &menu_about = *Gtk::manage(new Gtk::ImageMenuItem(Gtk::Stock::ABOUT));
  menu.append(menu_about);
  menu_about.signal_activate().connect(sigc::mem_fun(*this, &TrayIcon::on_show_about));
  Gtk::ImageMenuItem &menu_quit = *Gtk::manage(new Gtk::ImageMenuItem(Gtk::Stock::QUIT));
  menu.append(menu_quit);
  menu_quit.signal_activate().connect(sigc::mem_fun(Main::instance(), &Main::stop_main_loop));
  menu.show_all();
  icon->signal_popup_menu().connect(sigc::mem_fun(*this, &TrayIcon::on_show_popup));
}

TrayIcon::~TrayIcon()
{
}

void TrayIcon::on_show_about()
{
  Gtk::AboutDialog about;
  about.set_copyright("Copyright (C) 2011 Ben Asselstine");
  about.set_version(PACKAGE_VERSION);
  about.set_program_name(Glib::get_prgname());
  about.set_logo(Gdk::Pixbuf::create_from_file (Main::get_data_path() + "/data/mouse-graph.png"));
  about.set_website("http://www.nongnu.org/mouse-graph");
  about.set_comments("The most important feature of this program is freedom.");
  about.set_license("This software is licensed under the terms of the \nGNU General Public License Version 3.\nhttp://www.gnu.org/licenses/gpl.html");
  std::vector<Glib::ustring> authors;
  authors.push_back("Ben Asselstine");
  about.set_authors(authors);
  std::vector<Glib::ustring> artists;
  artists.push_back("Ben Asselstine");
  about.set_artists(artists);
  about.run();
  about.hide();
}

void TrayIcon::on_show_popup(guint button, guint32 activate_time) 
{
  if (icon)
    icon->popup_menu_at_position(menu, button, activate_time);
}

void TrayIcon::toggle_mouse_graphing()
{
  Main::instance().toggle_mouse_graphing();
  if (Main::instance().is_graphing())
    {
      icon->set_from_file(Main::get_data_path() + "/data/mouse-graph-recording.png");
      menu_check.set_sensitive(true);
    }
  else
    {
      icon->set_from_file(Main::get_data_path() + "/data/mouse-graph.png");
      menu_check.set_sensitive(false);
    }
}

void TrayIcon::on_show_graph()
{
  Main::instance().graph_it();
}
