// -*- mode: c++; indent-tabs-mode: nil; c-basic-offset: 4 -*-
// $Header: /home/pgavin/cvsroot/mpak/include/mpak/builtins/config_node.hh,v 1.1 2004/07/01 22:45:37 pgavin Exp $
// mpak - the advanced package manager
// Copyright (C) 2003 Peter Gavin
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __MPAK__BUILTINS__CONFIG_NODE_HH__
#define __MPAK__BUILTINS__CONFIG_NODE_HH__

#include <mpak/defs.hh>
#include <mpak/spec/node.hh>
#include <mpak/builtins/mpak_node.hh>

#include <boost/weak_ptr.hpp>
#include <boost/shared_ptr.hpp>
#include <boost/filesystem/path.hpp>

#include <string>
#include <ostream>

namespace mpak
{
    namespace builtins
    {
        class config_node
            : public mpak_node
        {
            boost::filesystem::path package_tree_dir_;
            boost::filesystem::path statedb_dir_;
            boost::filesystem::path mpaktmp_dir_;
            boost::filesystem::path source_dir_;
            boost::filesystem::path root_dir_;
            
        public:
            config_node (const std::string &type, const std::string &name,
                         spec::context &context,
                         const bool serialized_init = false);
            
        public:
            virtual
            ~config_node (void);
            
            const boost::filesystem::path &
            get_package_tree_dir (void)
                const
            {
                this->init ();
                return this->package_tree_dir_;
            }
            
            void
            set_package_tree_dir (const boost::filesystem::path &package_tree_dir)
            {
                this->init ();
                this->package_tree_dir_ = package_tree_dir;
            }
            
            const boost::filesystem::path &
            get_statedb_dir (void)
                const
            {
                this->init ();
                return this->statedb_dir_;
            }
            
            void
            set_statedb_dir (const boost::filesystem::path &statedb_dir)
            {
                this->init ();
                this->statedb_dir_ = statedb_dir;
            }
            
            const boost::filesystem::path &
            get_mpaktmp_dir (void)
                const
            {
                this->init ();
                return this->mpaktmp_dir_;
            }
            
            void
            set_mpaktmp_dir (const boost::filesystem::path &mpaktmp_dir)
            {
                this->init ();
                this->mpaktmp_dir_ = mpaktmp_dir;
            }
            
            const boost::filesystem::path &
            get_source_dir (void)
                const
            {
                this->init ();
                return this->source_dir_;
            }
            
            void
            set_source_dir (const boost::filesystem::path &source_dir)
            {
                this->source_dir_ = source_dir;
            }
            
            const boost::filesystem::path &
            get_root_dir (void)
                const
            {
                this->init ();
                return this->root_dir_;
            }
            
            void
            set_root_dir (const boost::filesystem::path &root_dir)
            {
                this->root_dir_ = root_dir;
            }
        };
    }
}

#endif // ifndef __MPAK__BUILTINS__CONFIG_NODE_HH__
