// -*- mode: c++; indent-tabs-mode: nil; c-basic-offset: 4 -*-
// $Header: /home/pgavin/cvsroot/mpak/include/mpak/spec/database_pickler.hh,v 1.3 2004/07/01 22:45:37 pgavin Exp $
// mpak - the advanced package manager
// Copyright (C) 2003 Peter Gavin
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __MPAK__SPEC__DATABASE_PICKLER_HH__
#define __MPAK__SPEC__DATABASE_PICKLER_HH__

#include <mpak/spec/pickler.hh>
#include <mpak/spec/command_info.hh>

#include <boost/shared_ptr.hpp>
#include <boost/scoped_ptr.hpp>
#include <boost/filesystem/path.hpp>

#include <string>
#include <stdexcept>

namespace mpak
{
    namespace spec
    {
        namespace detail
        {
            struct database_pickler_impl_;
        }
        
        class database_pickler
            : public pickler
        {
            boost::scoped_ptr<detail::database_pickler_impl_> impl_;
            const boost::filesystem::path database_path_;
        public:
            
            database_pickler (const boost::filesystem::path &database_path);
            
            virtual ~database_pickler (void);
            
            virtual const boost::shared_ptr<command_info_list>
            read (const std::string &node_type,
                  const util::node_path &node_path)
                const;
            virtual const boost::shared_ptr<command_info_list>
            read (void)
                const;
            virtual void
            write (const std::string &node_type,
                   const util::node_path &node_path,
                   const boost::shared_ptr<const command_info_list> &command_infos)
                const;
            virtual void
            write (const boost::shared_ptr<const command_info_list> &command_infos)
                const;
            
            virtual void
            remove (const std::string &node_type, const util::node_path &node_path)
                const;
            
        private:
            const boost::shared_ptr<command_info_list>
            read_helper_ (const std::string &key)
                const;
            void
            write_helper_ (const std::string &key,
                           const boost::shared_ptr<const command_info_list> &command_infos)
                const;
        };
    }
}

#endif // ifndef __MPAK__SPEC__DATABASE_PICKLER_HH__
