// -*- mode: c++; indent-tabs-mode: nil; c-basic-offset: 4 -*-
// $Header: /home/pgavin/cvsroot/mpak/include/mpak/spec/file_pickler.hh,v 1.1.1.1 2004/05/21 01:50:30 pgavin Exp $
// mpak - the advanced package manager
// Copyright (C) 2003 Peter Gavin
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __MPAK__SPEC__FILE_PICKLER_HH__
#define __MPAK__SPEC__FILE_PICKLER_HH__

#include <mpak/spec/pickler.hh>
#include <mpak/spec/command_info.hh>
#include <mpak/util/node_path.hh>

#include <boost/shared_ptr.hpp>
#include <boost/filesystem/path.hpp>

#include <string>
#include <stdexcept>

namespace mpak
{
    namespace spec
    {
        class file_pickler
            : public pickler
        {
            const boost::filesystem::path file_path_;
            
        public:
            
            file_pickler (const boost::filesystem::path file_path)
                : file_path_ (file_path)
            {
            }
            
            virtual ~file_pickler (void);
            
            virtual const boost::shared_ptr<command_info_list>
            read (void)
                const;
        };
    }
}

#endif // ifndef __MPAK__SPEC__FILE_PICKLER_HH__
