// -*- mode: c++; indent-tabs-mode: nil; c-basic-offset: 4 -*-
// $Header: /home/pgavin/cvsroot/mpak/include/mpak/util/file_stat.hh,v 1.2 2004/07/06 17:20:31 pgavin Exp $
// mpak - the advanced package manager
// Copyright (C) 2003 Peter Gavin
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __MPAK__UTIL__FILE_STAT_HH__
#define __MPAK__UTIL__FILE_STAT_HH__

#include <mpak/util/checksummer.hh>

#include <boost/filesystem/path.hpp>
#include <boost/optional.hpp>

#include <string>

#include <sys/stat.h>
#include <time.h>
#include <sys/time.h>

namespace mpak
{
    namespace util
    {
        class file_stat
        {
        public:
            class failure
                : public std::runtime_error
            {
            public:
                inline failure (const std::string &what)
                    : runtime_error (what)
                {
                }
            };
            
            file_stat (void)
            {
            }
            
            explicit
            file_stat (const boost::filesystem::path &path, checksummer::algorithm checksum_algo = checksummer::algorithm_default)
            {
                this->get_stats_from_path (path, checksum_algo);
            }
            
            enum file_type {
                type_directory,
                type_chardev,
                type_blkdev,
                type_regular,
                type_fifo,
                type_symlink,
                type_socket
            };
            
            file_type type;
            mode_t mode;
            uid_t uid;
            gid_t gid;
            off_t size;
            dev_t devnum;
            long mtime;
            boost::optional<std::string> symlink_target;
            checksummer::algorithm checksum_algo;
            checksummer::checksum_type checksum;
            
            void swap (file_stat &that)
            {
                std::swap (this->type, that.type);
                std::swap (this->mode, that.mode);
                std::swap (this->uid, that.uid);
                std::swap (this->gid, that.gid);
                std::swap (this->size, that.size);
                std::swap (this->devnum, that.devnum);
                std::swap (this->mtime, that.mtime);
                boost::swap (this->symlink_target, that.symlink_target);
                std::swap (this->checksum_algo, that.checksum_algo);
                std::swap (this->checksum, that.checksum);
            }
            
            void
            get_stats_from_path (const boost::filesystem::path &path, checksummer::algorithm checksum_algo = checksummer::algorithm_default);
        };
    }
}

#endif // ifndef __MPAK__UTIL__VERSION_SPEC_HH__
