// -*- mode: c++; indent-tabs-mode: nil; c-basic-offset: 4 -*-
// $Header: /home/pgavin/cvsroot/mpak/libmpak/mpak/builtins/sources_node_data.cc,v 1.4 2004/07/01 22:45:37 pgavin Exp $
// mpak - the advanced package manager
// Copyright (C) 2003 Peter Gavin
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <config.h>

#include <mpak/builtins/sources_node_data.hh>

namespace mpak
{
    namespace builtins
    {
        sources_node_data *
        sources_node_data::
        clone (void)
            const
        {
            return new sources_node_data (*this);
        }
        
        void
        sources_node_data::
        merge (const boost::shared_ptr<node_data> &that_node_data)
            const
        {
            boost::shared_ptr<sources_node_data> that (boost::dynamic_pointer_cast<sources_node_data> (that_node_data));
            assert (that);
            
            that->source_map_ = this->source_map_;
            that->checksum_map_ = this->checksum_map_;
        }
        
        sources_node_data::~sources_node_data (void)
        {
        }
    }
}
