// -*- mode: c++; indent-tabs-mode: nil; c-basic-offset: 4 -*-
// $Header: /home/pgavin/cvsroot/mpak/libmpak/mpak/spec/grammar.hh,v 1.2 2004/05/29 15:52:12 pgavin Exp $
// mpak - the advanced package manager
// Copyright (C) 2003 Peter Gavin
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __MPAK__SPEC__GRAMMAR_HH__
#define __MPAK__SPEC__GRAMMAR_HH__

#include <mpak/spec/command_info.hh>

#include <boost/shared_ptr.hpp>
#include <boost/variant.hpp>
#include <boost/spirit/debug.hpp>
#include <boost/spirit/core.hpp>
#include <boost/spirit/attribute.hpp>

#include <list>
#include <string>

namespace mpak
{
    namespace spec
    {
        namespace detail
        {
            struct space_grammar;
            struct string_grammar;
            struct argument_list_grammar;
            struct command_list_grammar;
            
            //////////////////////////////////////////////////
            // space_grammar
            
            struct space_grammar
                : public boost::spirit::grammar<space_grammar>
            {
                template<class scanner_type_>
                struct definition
                {
                    typedef boost::spirit::rule<scanner_type_> rule_type;
                    
                    rule_type start_;
                    
                    definition (const space_grammar &space_grammar);
                    const boost::spirit::rule<scanner_type_> &
                    start (void) const;
                };
            };
            
            //////////////////////////////////////////////////
            // string_grammar
            
            struct string_closure
                : public boost::spirit::closure<string_closure, std::string>
            {
                member1 string_;
            };
            
            struct string_grammar
                : public boost::spirit::grammar<string_grammar, string_closure::context_t>
            {
                template<class scanner_type_>
                struct definition
                {
                    typedef string_closure::context_t context_type;
                    typedef boost::spirit::rule<scanner_type_, context_type> rule_type;
                    
                    rule_type start_;
                    rule_type qstring;
                    rule_type mlstring;
                    rule_type uqstring;
                    
                    definition (const string_grammar &string_grammar);
                    const boost::spirit::rule<scanner_type_, context_type> &
                    start (void) const;
                };
            };
            
            //////////////////////////////////////////////////
            // argument_list_grammar
            
            struct argument_list_closure
                : public boost::spirit::closure<argument_list_closure, boost::shared_ptr<argument_vector> >
            {
                member1 arguments;
            };
            
            struct argument_list_grammar
                : public boost::spirit::grammar<argument_list_grammar, argument_list_closure::context_t>
            {
                template<class scanner_type_>
                struct definition
                {
                    typedef argument_list_closure::context_t context_type;
                    typedef boost::spirit::rule<scanner_type_, context_type> rule_type;
                    
                    rule_type start_;
                    rule_type argument;
                    rule_type block;
                    string_grammar string;
                    command_list_grammar command_list;
                    space_grammar space;
                    
                    definition (const argument_list_grammar &argument_list_grammar);
                    const boost::spirit::rule<scanner_type_, context_type> &
                    start (void) const;
                };
            };
            
            //////////////////////////////////////////////////
            // command_grammar
            
            struct command_closure
                : public boost::spirit::closure<command_closure, command_info>
            {
                member1 command_info_;
            };
            
            struct command_grammar
                : public boost::spirit::grammar<command_grammar, command_closure::context_t>
            {
                template<class scanner_type_>
                struct definition
                {
                    typedef command_closure::context_t context_type;
                    typedef boost::spirit::rule<scanner_type_, context_type> rule_type;
                    
                    rule_type start_;
                    argument_list_grammar argument_list;
                    rule_type qidentifier;
                    rule_type identifier;
                    space_grammar space;
                    
                    definition (const command_grammar &command_grammar);
                    const boost::spirit::rule<scanner_type_, context_type> &
                    start (void) const;
                };
            };
            
            //////////////////////////////////////////////////
            // command_list_grammar
            
            struct command_list_closure
                : public boost::spirit::closure<command_list_closure, boost::shared_ptr<command_info_list> >
            {
                member1 command_infos;
            };
            
            struct command_list_grammar
                : public boost::spirit::grammar<command_list_grammar, command_list_closure::context_t>
            {
                template<class scanner_type_>
                struct definition
                {
                    typedef command_list_closure::context_t context_type;
                    typedef boost::spirit::rule<scanner_type_, context_type> rule_type;
                    
                    rule_type start_;
                    detail::command_grammar command;
                    rule_type command_sep;
                    rule_type comment;
                    detail::space_grammar space;
                    
                    definition (const command_list_grammar &command_list_grammar);
                    const boost::spirit::rule<scanner_type_, context_type> &
                    start (void) const;
                };
            };
            
            //////////////////////////////////////////////////
            // grammar
            
            struct closure
                : public boost::spirit::closure<closure, boost::shared_ptr<command_info_list> >
            {
                member1 command_infos;
            };
            
            struct grammar
                : public boost::spirit::grammar<grammar, closure::context_t>
            {
                template<class scanner_type_>
                struct definition
                {
                    typedef closure::context_t context_type;
                    typedef boost::spirit::rule<scanner_type_, context_type> rule_type;
                    
                    rule_type start_;
                    detail::command_list_grammar command_list;
                    
                    definition (const grammar &grammar);
                    const boost::spirit::rule<scanner_type_, context_type> &
                    start (void) const;
                };
            };
        }
    }
}

#include <mpak/spec/grammar.tcc>

#endif // ifndef __MPAK_SPEC__GRAMMAR_H__
