// -*- mode: c++; indent-tabs-mode: nil; c-basic-offset: 4 -*-
// $Header: /home/pgavin/cvsroot/mpak/libmpak/mpak/util/node_path_grammar.hh,v 1.2 2004/05/29 15:52:12 pgavin Exp $
// mpak - the advanced package manager
// Copyright (C) 2003 Peter Gavin
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __MPAK__UTIL__NODE_PATH_GRAMMAR_HH__
#define __MPAK__UTIL__NODE_PATH_GRAMMAR_HH__

#include <mpak/util/node_path.hh>

#include <boost/spirit.hpp>
#include <boost/spirit/phoenix.hpp>

#include <string>
#include <sstream>

namespace mpak
{
    namespace util
    {
        struct node_path_closure
            : public boost::spirit::closure<node_path_closure, node_path>
        {
            member1 node_path_;
        };
        
        struct node_path_grammar
            : public boost::spirit::grammar<node_path_grammar, node_path_closure::context_t>
        {
            template<class scanner_type_>
            struct definition
            {
                typedef boost::spirit::rule<scanner_type_> rule_type;
                rule_type start_;
                rule_type path;
                
                definition (const node_path_grammar &self)
                {
                    using boost::spirit::ch_p;
                    using boost::spirit::alnum_p;
                    using boost::spirit::anychar_p;
                    using boost::spirit::space_p;
                    using boost::spirit::chset_p;
                    
                    using phoenix::bind;
                    using phoenix::arg1;
                    using phoenix::arg2;
                    using phoenix::construct_;
                    
                    start_ =
                        (chset_p ("A-Za-z0-9_") >> *chset_p("A-Za-z0-9_+-."))[bind (&node_path::push_back_element) (self.node_path_,
                                                                                                                    construct_<std::string> (arg1, arg2))] %
                        ch_p (':');
                    
                    BOOST_SPIRIT_DEBUG_NODE(start_);
                    BOOST_SPIRIT_DEBUG_NODE(path);
                }
                
                const boost::spirit::rule<scanner_type_> &
                start (void) const
                {
                    return this->start_;
                }
            };
        };
    }
}

#endif // ifndef __MPAK__UTIL__NODE_PATH_GRAMMAR_HH__
