// -*- mode: c++; indent-tabs-mode: nil; c-basic-offset: 4 -*-
// $Header: /home/pgavin/cvsroot/mpak/libmpak/mpak/spec/pickler.cc,v 1.3 2004/07/01 22:45:37 pgavin Exp $
// mpak - the advanced package manager
// Copyright (C) 2003 Peter Gavin
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <config.h>

#include <mpak/spec/pickler.hh>
#include <mpak/spec/fwd.hh>
#include <mpak/spec/node.hh>
#include <mpak/spec/command_info.hh>

#include <boost/shared_ptr.hpp>

#include <string>
#include <stdexcept>

namespace mpak
{
    namespace spec
    {
        const boost::shared_ptr<command_info_list>
        pickler::
        read (void)
            const
        {
            throw failure ("default read not implemented");
        }
        
        const boost::shared_ptr<command_info_list>
        pickler::
        read (const std::string &node_type, const util::node_path &node_path)
            const
        {
            throw failure ("read not implemented, node type: " + node_type + ", path: " + node_path.get_string ());
        }
        
        void
        pickler::
        write (const boost::shared_ptr<const command_info_list> &command_infos)
            const
        {
            throw failure ("default write not implemented");
        }
        
        void
        pickler::
        write (const std::string &node_type, const util::node_path &node_path, const boost::shared_ptr<const command_info_list> &command_infos)
            const
        {
            throw failure ("write not implemented, node type: " + node_type + ", path: " + node_path.get_string ());
        }
        
        pickler::
        ~pickler (void)
        {
        }
        
        void
        pickler::
        remove (const std::string &node_type, const util::node_path &node_path)
            const
        {
            throw failure ("remove not implemented, node type: " + node_type + ", path: " + node_path.get_string ());
        }
    }
}
