// -*- mode: c++; indent-tabs-mode: nil; c-basic-offset: 4 -*-
// $Header: /home/pgavin/cvsroot/mpak/libmpak/mpak/spec/tree_pickler.cc,v 1.4 2004/07/01 22:45:37 pgavin Exp $
// mpak - the advanced package manager
// Copyright (C) 2003 Peter Gavin
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <config.h>

#include <mpak/spec/tree_pickler.hh>
#include <mpak/spec/command_info.hh>
#include <mpak/spec/grammar.hh>
#include <mpak/util/node_path.hh>

#include <boost/shared_ptr.hpp>
#include <boost/spirit.hpp>

#include <string>

namespace mpak
{
    namespace spec
    {
        tree_pickler::
        ~tree_pickler (void)
        {
        }
        
        namespace
        {
            const boost::shared_ptr<command_info_list>
            read_helper (const boost::filesystem::path &file_path)
            {
                const std::string filename (file_path.native_file_string ());
                boost::spirit::file_iterator<char> begin (filename);
                if (!begin) {
                    throw pickler::failure ("unable to open file: " + filename);
                }
                boost::spirit::file_iterator<char> end (begin.make_end ());
                
                mpak::spec::detail::grammar g;
                BOOST_SPIRIT_DEBUG_NODE (g);
                boost::shared_ptr<mpak::spec::command_info_list> command_infos;
                boost::spirit::parse_info<boost::spirit::file_iterator<char> >
                    info (boost::spirit::parse (begin, end,
                                                g[phoenix::var (command_infos) = phoenix::arg1]));
                
                if (!info.full)
                    throw pickler::failure ("parse failed, remaining input: " + std::string (info.stop, end));
                
                return command_infos;
            }
        }
        
        const boost::shared_ptr<command_info_list>
        tree_pickler::
        read (void)
            const
        {
            const boost::filesystem::path file_path (this->root_path_ / ".root.spec");
            return read_helper (file_path);
        }
        
        const boost::shared_ptr<command_info_list>
        tree_pickler::
        read (const std::string &node_type, const util::node_path &node_path)
            const
        {
            const boost::filesystem::path file_path (this->root_path_ / this->build_file_path_ (node_type, node_path));
            return read_helper (file_path);
        }
        
        const boost::filesystem::path
        tree_pickler::
        build_file_path_ (const std::string &node_type, const util::node_path &node_path)
            const
        {
            boost::filesystem::path file_path_prefix;
            for (util::node_path::element_const_iterator ei (node_path.begin_elements ()); ei != node_path.end_elements (); ++ei) {
                file_path_prefix /= *ei;
            }
            std::string filename;
            std::string::size_type colon (node_type.rfind (':'));
            return file_path_prefix / ('.' + node_type.substr (colon + 1) + ".spec");
        }
    }
}
