# Copyright 2010, 2015 Dmitry Samoyloff
# Distributed under the terms of the GNU General Public License v3
# $Header: $


#
# WARNING: Gentoo ebuild is obsolete and unsupported currently!'
#          If you want to maintain it -- you're welcome!"
#


inherit eutils

DESCRIPTION="Collects playback statistics of Music Player Daemon"
HOMEPAGE="http://mpd-hits.nongnu.org"
SRC_URI="http://download.savannah.nongnu.org/releases/mpd-hits/${P}.tar.bz2"

LICENSE="GPL-3"
SLOT="0"
KEYWORDS="~amd64"
IUSE=""

# dev-perl/Audio-MPD is from "mpd" overlay.
# >=dev-perl/Audio-MPD-1.092950 needs "perl-experimental" overlay.
# dev-perl/Proc-PID-File is from "sunrise" overlay.
RDEPEND="dev-lang/perl
	dev-perl/Audio-MPD
	>=dev-perl/Getopt-Mixed-1.006
	dev-perl/Proc-Daemon
	dev-perl/Proc-PID-File
	perl-core/Sys-Syslog
	dev-perl/Config-Simple
	perl-core/Time-Local
	dev-perl/DateTime-Format-Strptime
	dev-perl/Sort-Versions
	dev-perl/Audio-FLAC-Header
	dev-perl/Ogg-Vorbis-Header-PurePerl"

pkg_setup() {
	enewgroup mpd-hits
	enewuser mpd-hits "" "" "/var/lib/mpd-hits" mpd-hits
}

src_compile() {
	emake PREFIX=/usr || die "emake failed"
}

src_install() {
	emake DESTDIR="${D}/" PREFIX=/usr \
		install install-man || die "emake install failed"

	# Install generic documentation.
	dodoc README

	# Install configuration file.
	insinto /etc
	newins "mpd-hits.conf" mpd-hits.conf

	# Install initscript
	newinitd "gentoo/initscript" mpd-hits

	# This directory contains statistics' DB.
	diropts -m0755 -o mpd-hits -g mpd-hits
	dodir /var/lib/mpd-hits
	keepdir /var/lib/mpd-hits

	# Directory where PID lock would be created.
	diropts -m0755 -o mpd-hits -g mpd-hits
	dodir /var/run/mpd-hits
	keepdir /var/run/mpd-hits
}

pkg_postinst() {
	# Fix directories' permissions if they existed before.
	chown -f -R mpd-hits:mpd-hits /var/lib/mpd-hits
	chmod -f 0775 /var/lib/mpd-hits
	chmod -f 0664 /var/lib/mpd-hits/*
	chown -f -R mpd-hits:mpd-hits /var/run/mpd-hits
	chmod -f 0755 /var/run/mpd-hits
	chmod -f 0644 /var/run/mpd-hits/*

	# Change the homedir if the user has existed before.
	usermod -d "/var/lib/mpd-hits" mpd-hits
}
