/* This file is part of the MPFRCPP Library.

  Copyright (c) 2006 -- 2007 Alexey V. Beshenov <bav.272304@gmail.com>.

  The MPFRCPP Library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 2.1 of the
  License, or (at your option) any later version.

  The MPFRCPP Library is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with the MPFRCPP Library; see the file COPYING.LIB. If
  not, write to the Free Software Foundation, Inc., 51 Franklin Street,
  Fifth Floor, Boston, MA 02110-1301, USA. */

/**
 * @file simple_functions.hpp
 * @date 2007-04-09
 *
 * Overloads the folowing functions:
 *     abs, acos, acosh, agm, asin, asinh, atan2, atan, atanh, cbrt, ceil,
 *     cos, cosh, cot, coth, csc, csch, eint, erf, erfc, exp10, exp2, exp,
 *     expm1, factorial, floor, fma, frac, gamma, hypot, lngamma, log10,
 *     log1p, log2, log, pow, root, round, sec, sech, sin, sinh, sqr, sqrt,
 *     tan, tanh, trunc, zeta
 * in the mpfrcpp namespace.
 *
 * Could conflict with std_overloads.hpp,
 * DO NOT USE with std_overloads.hpp.
 *
 * OPTIONAL HEADER, INCLUDE ONLY IF NEEDED.
 */

#ifndef MPFRCPP_EXTRA_SIMPLE_FUNCTIONS
#define MPFRCPP_EXTRA_SIMPLE_FUNCTIONS

#include <mpfrcpp/mpfrcpp.hpp>

namespace mpfrcpp {

    inline Real abs (const Real& x) throw() {
        return Abs(x);
    }

    inline Real acos (const Real& x) throw() {
        return Acos(x);
    }

    inline Real acosh (const Real& x) throw() {
        return Acosh(x);
    }

    inline Real agm (const Real& x, const Real& y) throw() {
        return Agm(x, y);
    }

    inline Real asin (const Real& x) throw() {
        return Asin(x);
    }

    inline Real asinh (const Real& x) throw() {
        return Asinh(x);
    }

    inline Real atan2 (const Real& x, const Real& y) throw() {
        return Atan2(x, y);
    }

    inline Real atan (const Real& x) throw() {
        return Atan(x);
    }

    inline Real atanh (const Real& x) throw() {
        return Atanh(x);
    }

    inline Real cbrt (const Real& x) throw() {
        return Cbrt(x);
    }

    inline Real ceil (const Real& x) throw() {
        return Ceil(x);
    }

    inline Real cos (const Real& x) throw() {
        return Cos(x);
    }

    inline Real cosh (const Real& x) throw() {
        return Cosh(x);
    }

    inline Real cot (const Real& x) throw() {
        return Cot(x);
    }

    inline Real coth (const Real& x) throw() {
        return Coth(x);
    }

    inline Real csc (const Real& x) throw() {
        return Csc(x);
    }

    inline Real csch (const Real& x) throw() {
        return Csch(x);
    }

    inline Real eint (const Real& x) throw() {
        return Eint(x);
    }

    inline Real erf (const Real& x) throw() {
        return Erf(x);
    }

    inline Real erfc (const Real& x) throw() {
        return Erfc(x);
    }

    inline Real exp10 (const Real& x) throw() {
        return Exp10(x);
    }

    inline Real exp2 (const Real& x) throw() {
        return Exp2(x);
    }

    inline Real exp (const Real& x) throw() {
        return Exp(x);
    }

    inline Real expm1 (const Real& x) throw() {
        return Expm1(x);
    }

    inline Real factorial (unsigned int x) throw() {
        return Factorial(x);
    }

    inline Real floor (const Real& x) throw() {
        return Floor(x);
    }

    inline Real fma (const Real& x, const Real& y, const Real& z) throw() {
        return Fma(x,y,z);
    }

    inline Real frac (const Real& x) throw() {
        return Frac(x);
    }

    inline Real gamma (const Real& x) throw() {
        return Gamma(x);
    }

    inline Real hypot (const Real& x, const Real& y) throw() {
        return Hypot(x, y);
    }

    inline Real lngamma (const Real& x) throw() {
        return Lngamma(x);
    }

    inline Real log10 (const Real& x) throw() {
        return Log10(x);
    }

    inline Real log1p (const Real& x) throw() {
        return Log1p(x);
    }

    inline Real log2 (const Real& x) throw() {
        return Log2(x);
    }

    inline Real log (const Real& x) throw() {
        return Log(x);
    }

    inline Real pow (const Real& x, const Real& y) throw() {
        return Pow (x, y);
    }
    inline Real pow (const Real& x, int& y) throw() {
        return Pow (x, y);
    }
    inline Real pow (const Real& x, const mpz_t& y) throw() throw() {
        return Pow (x, y);
    }
    inline Real pow (const Real& x, const mpz_class& y) throw() throw() {
        return Pow (x, y);
    }

    inline Real root (const Real& x, unsigned int k) throw() {
        return Root(x, k);
    }

    inline Real round (const Real& x) throw() {
        return Round(x);
    }

    inline Real sec (const Real& x) throw() {
        return Sec(x);
    }

    inline Real sech (const Real& x) throw() {
        return Sech(x);
    }

    inline Real sin (const Real& x) throw() {
        return Sin(x);
    }

    inline Real sinh (const Real& x) throw() {
        return Sinh(x);
    }

    inline Real sqr (const Real& x) throw() {
        return Sqr(x);
    }

    inline Real sqrt (const Real& x) throw() {
        return Sqrt(x);
    }

    inline Real tan (const Real& x) throw() {
        return Tan(x);
    }

    inline Real tanh (const Real& x) throw() {
        return Tanh(x);
    }

    inline Real trunc (const Real& x) throw() {
        return Trunc(x);
    }

    inline Real zeta (const Real& x) throw() {
        return Zeta(x);
    }

}     // namespace mpfrcpp

#endif    // MPFRCPP_EXTRA_SIMPLE_FUNCTIONS
