/***************************************************************
 *                    simula+@metz.ensam.fr                    *
 *                   GNU/linux version 2.6.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright © 2006,2009,2010 COLLARD Christophe
 * copyright © 2006,2009,2010 Centre National de la Recherche Scientifique
 * copyright © 2006,2009,2010 Arts et Métiers ParisTech
 * copyright © 2006,2009,2010 Laboratoire de Physique et Mécanique des Matériaux (LPMM - CNRS)
 ***************************************************************/

/*
    tests-MPISOL++ belongs to Message Passing Interface for Simula+ Object Libraries (MPISOL++)
    MPISOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for the type interface.
#endif

#if !defined (__MPI_H)
#include <mpi.h>
#endif

#if !defined(__IOSTREAM_H)
#include <iostream>
#endif

#if !defined(__FSTREAM_H)
#include <fstream>
#endif

#if !defined(__STDIO_H)
#include <stdio.h>
#endif

#if !defined (__STDLIB_H)
#include <stdlib.h>
#endif

#if !defined(__TIME_H)
#include <time.h>
#endif

#if !defined(__COLORS_H)
#include "colors.h"
#endif

#if !defined(__BROADCAST_TEST_H)
#include "broadcast-test.h"
#endif

//#if !defined(__SECURE_BROADCAST_TEST_H)
//#include "secure broadcast-test.h"
//#endif

#if !defined(__SEND_RECEIVE_TEST_H)
#include "send receive-test.h"
#endif

using namespace std;
using namespace mpisol;


main()
{
  bool detail; // parameter to write/hide test procedure
  bool result = true;
  clock_t start, end;
  clock_t start_main, end_main;

  int argc;
  char** argv;
  MPI::Init(argc, argv);
  int myrank = MPI::COMM_WORLD.Get_rank();

  if (!myrank)
    { detail = 1;
      start_main = start = clock();
      if (detail)
	//=======================================================================
	cout<< "-------------------------broadcast-------------------------- \n";
        //=======================================================================
    }
  result *= test_broadcast(detail);
  if (!myrank)
    { end = clock();
      cout<<"cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

      cout << endl;

      detail = 1;
      start = clock();
      if (detail)
	//=======================================================================
	cout<< "------------------------send receive------------------------ \n";
        //=======================================================================
    }
  result *= test_send_receive(detail);
  if (!myrank)
    { end = clock();
      cout<<"cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;

      cout << endl;
    }

  MPI::Finalize();

  if (!myrank)
    { end_main = clock();
      cout << endl;

      cout << "============================================================== \n";
      if (result) cout << green << "-------OK------------end of MPIOL++ tests------------OK-------" << reset;
      else cout << red << "-----FAILED----------end of MPIOL++ tests----------FAILED-----" << reset;
      cout << "============================================================== \n";

      cout<<"cpu time : " << (long double)(end_main-start_main)/CLOCKS_PER_SEC << endl;
    }
}


