#!/usr/bin/env ruby

# Copyright (C) 2004, 2005  National Institute of Advanced Industrial Science and Technology
#
# This file is part of msgcab.
#
# msgcab is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# msgcab is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with msgcab; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

$KCODE = 'UTF8'
$SAFE = 1

require 'webapp'
require 'msgcab/config'
require 'msgcab/webapp/msgcab_controller'
require 'msgcab/plugin'

MsgCab::FLAVOR = 'webapp'

controller = nil
plugin_loader = nil
WebApp do |webapp|
  MsgCab::Config.load(webapp.resource_path('config.yml'))
  controller ||= MsgCab::WebApp::MsgCabController.new
  plugin_loader ||= MsgCab::PluginLoader.new
  plugin_loader.attributes[:controller] = controller
  plugin_loader.start_plugins
  controller.handle_request(webapp)
end
