# Copyright (C) 2004, 2005  National Institute of Advanced Industrial Science and Technology
#
# This file is part of msgcab.
#
# msgcab is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# msgcab is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with msgcab; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

require 'msgcab/cli/common'
require 'msgcab/progressbar'
require 'msgcab/logger'
require 'time'

module MsgCab
  module CLI
    class Property < Common
      include Logging

      def load_rule(name)
        path = Config.absolute_path(Config['rule_dir'] || './rule') +
          "#{name}.rb"
        load(path.to_s)
        rule_class = self.class.const_get("#{name.split(/[-_]+/).collect {|word| word.capitalize}.join}Rule")
        rule_class.new
      end

      def update(props, numbers)
        numbers = (0 .. CLI.database.max).to_a if numbers.empty?
        pbar = ProgressBar.new('property', numbers.length) unless opts[:quiet]
        rules = Hash.new
        props.each do |prop|
          begin
            rules[prop] = load_rule(prop)
          rescue Exception => e
            log(2, "Failed to load #{prop} rule: #{e}")
            props.delete(prop)
          end
        end
        numbers.each do |number|
          props.each do |prop|
            result = CLI.database.property(number, prop)
            next if result && !opts[:force]
            result = rules[prop].apply(number)
            if result
              if prop == 'filter'
                folder, folder_number = result.split(':')
                CLI.database.update_filter(number, folder, folder_number.to_i)
              else
                CLI.database.update_property(number, prop, result)
              end
              log(2, "#{number} <<< #{prop}")
              log(3, result[/\A.{60}/])
            end
            pbar.inc unless opts[:quiet]
          end
        end
        run_callback(:after_property_update, props, numbers)
        pbar.finish unless opts[:quiet]
      end
    end
  end
end

module MsgCab
  class Database
    def update_filter(number, folder, folder_number)
      @adapter.execute(<<'End', number)
DELETE FROM filter WHERE number = ?
End
      @adapter.execute(<<'End', number, folder, folder_number, Time.now.utc.xmlschema)
INSERT INTO filter VALUES (?, ?, ?, ?)
End
    end

    def update_property(number, name, value)
      @adapter.execute(<<'End', number, name)
DELETE FROM property WHERE number = ? AND name = ?
End
      @adapter.execute(<<'End', number, name, value)
INSERT INTO property VALUES (?, ?, ?)
End
    end
  end
end
