-- Copyright (C) 2004, 2005  National Institute of Advanced Industrial Science and Technology

-- This file is part of msgcab.

-- msgcab is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.

-- msgcab is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License
-- along with msgcab; if not, write to the Free Software
-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

CREATE TABLE message (
	number INTEGER PRIMARY KEY,
	msg_id VARCHAR(255) NOT NULL,
	digest VARCHAR(255) NOT NULL,
	date CHAR(20) NOT NULL,
	nov TEXT NOT NULL
);

CREATE INDEX idx_message_msg_id ON message(msg_id);
CREATE INDEX idx_message_digest ON message(digest);
CREATE INDEX idx_message_date ON message(date);

CREATE TABLE property (
	number INTEGER PRIMARY KEY,
	name VARCHAR(255) NOT NULL,
	value TEXT NOT NULL
);

CREATE INDEX idx_property_name ON property(name);

CREATE TABLE header (
	number INTEGER NOT NULL,
	name VARCHAR(255) NOT NULL,
	body VARCHAR(255) NOT NULL
);

CREATE INDEX idx_header_number ON header(number);
CREATE INDEX idx_header_name ON header(name);
CREATE INDEX idx_header_body ON header(body);

CREATE TABLE reference (
	msg_id VARCHAR(255) NOT NULL,
	ref_id VARCHAR(255) NOT NULL
);

CREATE INDEX idx_reference_msg_id ON reference(msg_id);
CREATE INDEX idx_reference_ref_id ON reference(ref_id);

CREATE TABLE filter (
	number INTEGER NOT NULL,
	folder VARCHAR(255) NOT NULL,
	folder_number INTEGER NOT NULL,
	time CHAR(20)
);

CREATE INDEX idx_filter_number ON filter(number);
CREATE INDEX idx_filter_folder ON filter(folder);
CREATE INDEX idx_filter_folder_number ON filter(folder_number);
CREATE INDEX idx_filter_time ON filter(time);

CREATE TABLE disjoint (
	number INTEGER PRIMARY KEY,
	rank INTEGER,
	parent INTEGER
);

CREATE INDEX idx_disjoint_parent ON disjoint(parent);

CREATE TABLE parent (
	msg_id VARCHAR(255) PRIMARY KEY,
	ref_id VARCHAR(255) NOT NULL
);

CREATE INDEX idx_parent_ref_id ON parent(ref_id);

CREATE TABLE unresolved_parent (
	msg_id varchar(255) NOT NULL,
	ref_id varchar(255) NOT NULL
);

CREATE INDEX idx_unresolved_parent_msg_id ON unresolved_parent(msg_id);
CREATE INDEX idx_unresolved_parent_ref_id ON unresolved_parent(ref_id);
