# Copyright (C) 2004, 2005  National Institute of Advanced Industrial Science and Technology
#
# This file is part of msgcab.
#
# msgcab is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# msgcab is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with msgcab; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

require 'dbi'

module MsgCab
  class DBI
    def initialize
      url = Config['database', 'url']
      unless url
        path = Config.absolute_path(Config['database', 'path'] ||
                                      './db/database.sqlite')
        path.dirname.mkdir unless path.dirname.exist?
        url = "dbi:SQLite:#{path}"
      end
      @dbi = ::DBI.connect(url,
                           Config['database', 'user'],
                           Config['database', 'auth'],
                           Config['database', 'params'])
      @stmt_cache = Hash.new
    end

    def commit
      @dbi.commit
    end

    def disconnect
      @dbi.commit
      @dbi.disconnect
    end

    def prepare(stmt, name = nil)
      name ||= caller[0]
      s = @stmt_cache[name] ||= @dbi.prepare(stmt)
    end

    def execute(stmt, *bind_vars)
      prepare(stmt, caller[0]).execute(*bind_vars)
    end

    def select_all(stmt, *bind_vars)
      s = prepare(stmt, caller[0])
      s.execute(*bind_vars)
      s.fetch_all
    end

    def select_one(stmt, *bind_vars)
      s = prepare(stmt, caller[0])
      s.execute(*bind_vars)
      s.fetch
    end

    def tables
      @dbi.tables
    end
  end
end
