# Copyright (C) 2004, 2005  National Institute of Advanced Industrial Science and Technology
#
# This file is part of msgcab.
#
# msgcab is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# msgcab is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with msgcab; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

require 'msgcab/config'
require 'msgcab/webapp/view'

module MsgCab
  module WebApp
    class Error < StandardError; end
    class InvalidRequest < Error; end

    class Controller
      def initialize
        @actions = Array.new
      end

      def add_action(pat, function = nil, &block)
        raise InvalidArgument unless function || block_given?
        @actions.unshift([pat, function || block])
      end

      def handle_request(webapp)
        begin
          path = (webapp.path_info || '').sub(%r|\A/+|, '').sub(%r|/+\z|, '')
          action = @actions.detect {|pat, block| path =~ pat}
          unless action
            raise InvalidRequest, 'unknown request'
          end
          action[1].call(webapp, *$~.captures)
        rescue Error => e
          view = View.new(webapp)
          view.attributes[:cause] = e
          view.output_template('error.html')
        end
      end
    end
  end
end
