# Copyright (C) 2004, 2005  National Institute of Advanced Industrial Science and Technology
#
# This file is part of msgcab.
#
# msgcab is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# msgcab is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with msgcab; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

require 'estraier'

class EstraierPlugin < MsgCab::Plugin
  def start_plugin
    MsgCab::Callback.add_callback(:view_initialize, :add_estraier_anchor) do
      |view|
      view.add_anchor(:header, EstraierAnchor)
    end

    @controller = attributes[:controller]
    @controller.add_action(%r|\A#{MsgCab::WebApp::FolderPat}/search\z|,
                           method(:do_search).to_proc)
  end

  def do_search(webapp, folder_name)
    q = webapp.query_html_get_application_x_www_form_urlencoded
    q = q['q'].untaint
    index_path = MsgCab::Config['estraier', 'index_path'] ||
      './estraier'
    index_path = MsgCab::Config.absolute_path(index_path)
    index = ::Estraier::Database.new
    unless index.open(index_path.to_s, ::Estraier::Database::DBREADER)
      raise MsgCab::WebApp::Error, "couldn't open estraier index"
    end
    condition = ::Estraier::Condition::new
    condition.add_attr("folder STREQ #{folder_name}")
    condition.set_phrase(q)
    result = index.search(condition)
    summary = Array.new
    view = MsgCab::WebApp::View.new(webapp)
    (0 ... result.doc_num).each do |i|
      document = index.get_doc(result.get_doc_id(i), 0)
      next unless document
      uri = document.attr("@uri")
      number = @controller.mailtree.path_to_number(Pathname.new(URI(uri).path))
      folder, folder_number = @controller.database.to_folder_number(number)
      message = @controller.database.message(number)
      message.nov = message.nov.decode(view.encoding)
      summary << message
    end
    index.close
    view.attributes[:folder] = @controller.database.folder(folder_name)
    view.attributes[:summary] = summary
    view.attributes[:banner] =
      summary.empty? ? "#{folder_name}:no match for: #{q}" : 
      "#{folder_name}:#{summary.length} matches for: #{q}"
    view.output_template('summary.html')
  end
end

class EstraierAnchor < MsgCab::WebApp::Anchor
  def initialize(chain, view)
    super(chain, view)
  end

  include HTree.compile_template(<<'End')
<div _template="replace">
  <span _if="view.attributes[:folder]">
    <form _attr_action='view.uri("/#{view.attributes[:folder].name}/search")' accept-charset="UTF-8">
      <span _text='"Search in #{view.attributes[:folder].name}:"></span>
      <input type="text" size="16" name="q"/>
      <input type="submit" value="Search"/>
    </form>
  </span>
  <span _call="next_anchor.replace"></span>
</div>
End
end
