# Copyright (C) 2004, 2005  National Institute of Advanced Industrial Science and Technology
#
# This file is part of msgcab.
#
# msgcab is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# msgcab is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with msgcab; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

require 'test/unit'
require 'msgcab/logger'

include MsgCab

class TestLogger < Test::Unit::TestCase
  def test_s_open_device
    assert_equal($stdout, Logger.open_device('STDOUT'))
    assert_equal($stderr, Logger.open_device('STDERR'))
  end

  def log(logging_level, str, logger = nil)
    pr, pw = IO.pipe
    fork do
      pr.close
      $stdout.reopen(pw)
      logger = Logger.new('STDOUT') unless logger
      logger.log(logging_level, str)
      pw.close
    end
    pw.close
    result = pr.read
    Process.wait
    result
  end

  def test_initialize
    logger = Logger.new('STDOUT')
    assert_equal(Logger::DefaultLoggingLevel, logger.logging_level)
  end

  def test_log
    assert_match(/ test\n\z/, log(2, 'test'))
    assert_equal('', log(3, 'test'))
  end

  def test_logging
    path = Pathname.new(__FILE__).dirname + 'test-logger0.yml'
    Config.load(path)
    MsgCab.const_set(:FLAVOR, 'webapp')
    assert_equal('', log(3, 'test'))
    assert_match(/ test\n\z/, log(2, 'test'))
    MsgCab.module_eval {remove_const(:FLAVOR)}
    
    MsgCab.const_set(:FLAVOR, 'cli')
    assert_equal('', log(3, 'test'))
    assert_match(/ test\n\z/, log(2, 'test'))
    MsgCab.module_eval {remove_const(:FLAVOR)}
  end
end
