// muesli-erlang.c -*- C -*-
/* Interface to erlang evaluators / template for new language interfaces
   Copyright (C) 2008, 2009, 2010 University of Limerick

   This file is part of Muesli.
   
   Muesli is free software: you can redistribute it and/or modify it under
   the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your
   option) any later version.
   
   Muesli is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
   for more details.
   
   You should have received a copy of the GNU General Public License
   along with Muesli.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef _MUESLI_ERLANG_
#define _MUESLI_ERLANG_

#include "../config.h"
#include "muesli.h"
#include "muesli-internal.h"

#ifdef HAVE_LIBERL_INTERFACE

#include <stdio.h>
#include <limits.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <getopt.h>		// todo: do I need this?

#include <erl_interface.h>

static int ambient_transient = 0;

#if 0

// Getting args from your scripting language stack:
int erlang_count_args(erlang_state *S) { return 0; }
int erlang_number_arg(int argi) { return 0; }
char *erlang_string_arg(int argi) { return (char*)""; }
int erlang_arg_is_string(int argi) { return 0; }
int erlang_arg_is_number(int argi) { return 0; }

// Putting results back onto your scripting language stack:
void erlang_return_string(const char *string_back) {}
void erlang_return_number(float number_back) {}
void erlang_return_integer(int number_back) {}
void erlang_return_boolean(int int_back) {}
void erlang_return_void(erlang_state *S) {};

// Handling table / map / alist structures of your scripting language:
erlang_table *erlang_create_table(int size) { return NULL; }
void erlang_set_table_string(erlang_table *T, char *key, const char *value) {}
void erlang_set_table_number(erlang_table *T, char *key, float value) {}
void erlang_set_table_boolean(erlang_table *T, char *key, int value) {}

// Make a name / symbol of the scripting language:
erlang_symbol *erlang_make_symbol(const char *n) { return NULL; }

// Non-local exits in the scripting language
void erlang_throw(erlang_symbol *Y, float n) {}

// Set a global variable of the scripting language to contain a table:
void erlang_set_global_variable_table(erlang_symbol *varname, erlang_table *table) {}

// Extend the scripting language with an added built-in function:
void erlang_register_builtin_function(const char *funname, void (*function)(erlang_state *FS)) {}
#endif

// A specialized non-local exit; could either throw, or just quit the
// application run:
void erlang_error(char *message, char *arg)
{
  fprintf(stderr, "Got error \"%s\", \"%s\"\n", message, arg);
}

static evaluator_interface *erlang_interface = NULL;

static char *option_names_var_name = (char*)"option_names";

#if 0
static void
erlang_set_parameter()
{
  if (erlang_count_args(cs) < 2) {
    fprintf(stderr, "too few args to erlang_set_parameter\n");
    erlang_error(cs, (char*)"argcount", (char*)"set_parameter");
  }

  char option_code = muesli_find_option_letter(erlang_interface->getopt_options, erlang_string_arg(cs, 0));

  if (option_code != -1) {
    if (erlang_arg_is_string(cs, 1)) {
      (erlang_interface->handle_option)(erlang_interface->app_params,
					option_code,
					muesli_malloc_copy_string(erlang_string_arg(cs, 1)),
					0.0, 1,
					"erlang");
    } else if (erlang_arg_is_number(cs, 1)) {
      (erlang_interface->handle_option)(erlang_interface->app_params,
					option_code, NULL, erlang_number_arg(cs, 2), 1,
					"erlang");
    } else {
      (erlang_interface->handle_option)(erlang_interface->app_params,
					option_code, (char*)"true", 0.0, 1,
					"erlang");
    }
  }
}

static void
erlang_set_parameters()
{
  if (erlang_count_args(cs) < 1)  {
    fprintf(stderr, "too few args to erlang_set_parameters\n");
    erlang_error(cs, (char*)"argcount", (char*)"set_parameters");
  }

#if 0
  // Fill in: use a table iterator from your language
  erlang_table table = erlang_table_arg(cs, 0);

  erlang_table_iteration_start(cs, table);
  while (erlang_table_iteration_next(cs, table) != 0) {
    erlang_set_parameter(cs,
			 erlang_table_iteration_current_key(cs, table),
			 erlang_table_iteration_current_value(cs, table));
  }

#endif
}

static void
erlang_get_parameter()
{
  if (erlang_count_args(cs) < 1)  {
    fprintf(stderr, "too few args to erlang_get_parameter\n");
    erlang_error(cs, (char*)"argcount", (char*)"get_parameter");
  }

  char option_code = muesli_find_option_letter(erlang_interface->getopt_options,
					       erlang_string_arg(cs, 0));

  if (option_code != -1) {

muesli_value_t result = (erlang_interface->handle_option)(erlang_interface->app_params,
							  option_code,	// option
							  NULL, 0.0,	// value
							  0,	// set
							  "erlang");

    switch (result.type) {
    case muesli_value_string:
      erlang_return_string(cs, result.data.as_string);
      break;
    case muesli_value_float:
      erlang_return_number(cs, result.data.as_float);
      break;
    case muesli_value_integer:
      erlang_return_integer(cs, result.data.as_int);
      break;
    case muesli_value_boolean:
      erlang_return_boolean(cs, result.data.as_int);
      break;
    default:
      erlang_return_boolean(cs, 0);
      break;
    }
  }
}

static void
erlang_get_parameters()
{
  erlang_table *table = erlang_create_table(cs, 48);

  // todo: fix and re-instate -- I have to get long_options across to it somehow
  struct option *option_names = erlang_interface->getopt_options;

  while (option_names->name != 0) {
    
    muesli_value_t result = (erlang_interface->handle_option)(erlang_interface->app_params,
							      (option_names->val), // opt
							      NULL, 0.0, // value
							      0, // set
							      "erlang");

    switch (result.type) {
    case muesli_value_string:
      erlang_set_table_string(cs, table, (char*)(option_names->name), result.data.as_string);
      break;
    case muesli_value_float:
      erlang_set_table_number(cs, table, (char*)(option_names->name), result.data.as_float);
      break;
    case muesli_value_boolean:
      erlang_set_table_boolean(cs, table, (char*)(option_names->name), result.data.as_int);
      break;
    default:
      erlang_set_table_boolean(cs, table, (char*)(option_names->name), 0);
      break;
    }
    option_names++;
  }
}
#endif

///////////////////////////////////////
// Call arbitrary evaluators by name //
///////////////////////////////////////

#if 0
static int
muesli_erlang_eval_in_language()
{
  if (erlang_count_args(cs) < 2) {
    fprintf(stderr, "too few args to erlang_eval_in_language\n");
    erlang_error(cs, (char*)"argcount", (char*)"eval_in_language");
    return 0;
  }

  if ((erlang_arg_is_string(cs, 1)) && (erlang_arg_is_string(cs, 2))) {
    const char *language_name = erlang_string_arg(cs, 1);
    const char *evaluand = erlang_string_arg(cs, 2);
    unsigned int evaluand_length = strlen(evaluand);

    fprintf(stderr, "In erlang_eval_in_language(\"%s\", \"%s\")\n", language_name, evaluand);

    muesli_value_t result = muesli_eval_in_language(language_name,
						    evaluand,
						    evaluand_length,
						    ambient_transient);

    switch (result.type) {
    case muesli_value_float:
      erlang_return_number(cs, result.data.as_float);
      break;
    case muesli_value_integer:
      erlang_return_integer(cs, result.data.as_int);
      break;
    case muesli_value_string:
      erlang_return_string(cs, result.data.as_string);
      break;
    case muesli_value_boolean:
      erlang_return_boolean(cs, result.data.as_bool);
      break;
    case muesli_value_none:
    case muesli_value_error:
      erlang_return_boolean(cs, 0);
      break;
    }
  } else {
    fprintf(stderr, "wrong type args to erlang_eval_in_language\n");
    erlang_error(cs, (char*)"argtype", (char*)"eval_in_language");
    return 0;
  }
  return 1;
}
#endif

///////////////////////////////
// Custom built-in functions //
///////////////////////////////

#if 0
static void
erlang_eval_custom_function()
{
  if (erlang_arg_is_string(cs, 0)) {
    char *string_arg = erlang_string_arg(cs, 0);
    muesli_value_t result = (erlang_interface->eval_string)(erlang_interface,
							    string_arg, strlen(string_arg),
							    ambient_transient);
    switch (result.type) {
    case muesli_value_float:
      erlang_return_number(cs, result.data.as_float);
      break;
    case muesli_value_integer:
      erlang_return_integer(cs, result.data.as_int);
      break;
    case muesli_value_string:
      erlang_return_string(cs, result.data.as_string);
      break;
    case muesli_value_boolean:
      erlang_return_boolean(cs, result.data.as_int);
      break;
    case muesli_value_none:
    case muesli_value_error:
      erlang_return_void(cs);
      break;
    }
  } else {
    fprintf(stderr, "erlang_eval_function must be given a string\n");
    erlang_error(cs, (char*)"argtype", (char*)"erlang_eval");
  }
}
#endif

////////////////
// Initialize //
////////////////

void
erlang_evaluator_init(evaluator_interface *interface)
{
  // Init erlang interface

  erl_init(NULL, 0);
  erlang_interface = interface;

  // Extend system

#if 0
  // Fill in: register all these language extensions (as applicable):
  if (muesli_extensions & MUESLI_EXTENSION_SINGLE_PARAMETER) {
    Muesli_Add_Fn_1(interface, (char*)"get_parameter", erlang_get_parameter);
    Muesli_Add_Fn_2(interface, (char*)"set_parameter", erlang_set_parameter);
  }
  if (muesli_extensions & MUESLI_EXTENSION_PARAMETER_BLOCK) {
    Muesli_Add_Fn_0(interface, (char*)"parameters", erlang_get_parameters);
    Muesli_Add_Fn_1(interface, (char*)"modify_parameters", erlang_set_parameters);
  }
  if (muesli_extensions & MUESLI_EXTENSION_EVAL_IN_LANGUAGE) {
    Muesli_Add_Fn_1(interface, (char*)"eval_in_language", muesli_erlang_eval_in_language);
  }
  if (muesli_extensions & MUESLI_EXTENSION_CUSTOM) {
    Muesli_Add_Fn_1(interface, (char*)"custom", erlang_eval_custom_function);
  }
#endif
  // Set up option names

#if 0
  // Fill in: Create a table of option names.  You may well not need to bother.
  erlang_table *option_names_table = erlang_create_table(our_erlang_state, 48);
  struct option *option_names;
  for (option_names = erlang_interface->getopt_options;
       (option_names != NULL) && (option_names->name != 0);
       option_names++) {
    erlang_set_table_number(our_erlang_state, option_names_table,
			    (char*)(option_names->name), (option_names->val));
  }
  erlang_set_global_variable_table(our_erlang_state,
				   erlang_make_symbol(our_erlang_state,
						      option_names_var_name),
				   option_names_table);
#endif
}

static void
erlang_load_file(evaluator_interface *interface,
		const char *filename)
{
  int muesli_flags = interface->flags;
  if (muesli_flags & TRACE_MUESLI_LOAD) {
    fprintf(stderr, "Loading %s\n", filename);
  }
  // Fill in: load the functions file given as (char*)(filename)
  if (muesli_flags & TRACE_MUESLI_LOAD) {
    fprintf(stderr, "Loaded %s\n", filename);
  }
}

static muesli_value_t
erlang_eval_string(evaluator_interface *evaluator,
		   const char *erlang_c_string,
		   unsigned int string_length,
		   int transient)
{
  muesli_value_t result;
  ANULL_VALUE(result);

  if (erlang_c_string) {
    int old_ambient_transient = ambient_transient;
    ambient_transient = transient;
    // fprintf(stderr, "Erlang evaluating string \"%s\"\n", erlang_c_string);

    // Fill in: evaluate erlang_c_string, decide what kind of result
    // it returns, and fill in the result pointer and the result type
    // accordingly.



    ambient_transient = old_ambient_transient;
  }

  return result;
}

void
erlang_setup(evaluator_interface *new_erlang_interface)
{
  erlang_interface = new_erlang_interface;

  erlang_interface->eval_string = erlang_eval_string;
  erlang_interface->load_file = erlang_load_file;

#if 0
  erlang_interface->version = ERLANG_VERSION;
#endif
}

#endif
#endif

