// muesli-gs.c -*- C -*-
/* Interface to gs evaluators / template for new language interfaces
   Copyright (C) 2008, 2009, 2010 University of Limerick

   This file is part of Muesli.
   
   Muesli is free software: you can redistribute it and/or modify it under
   the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your
   option) any later version.
   
   Muesli is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
   for more details.
   
   You should have received a copy of the GNU General Public License
   along with Muesli.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef _MUESLI_GS_
#define _MUESLI_GS_

#include "../muesli-config.h"
#include "muesli.h"
#include "muesli-internal.h"

#ifdef HAVE_LIBGS

#include <stdio.h>
#include <limits.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <getopt.h>		// todo: do I need this?

#if 0
#include <ghost.h>
#endif

static int ambient_transient = 0;

#if 0

// A specialized non-local exit; could either throw, or just quit the
// application run:
void gs_error(gs_state *S, char *message, char *arg)
{
  fprintf(stderr, "Got error \"%s\", \"%s\"\n", message, arg);
}
#endif

static evaluator_interface *gs_interface = NULL;

static char *option_names_var_name = (char*)"option_names";

#if 0
static void
gs_set_parameter(gs_state *cs)
{
  if (gs_count_args(cs) < 2) {
    fprintf(stderr, "too few args to gs_set_parameter\n");
    gs_error(cs, (char*)"argcount", (char*)"set_parameter");
  }

  char option_code = muesli_find_option_letter(gs_interface->getopt_options, gs_string_arg(cs, 0));

  if (option_code != -1) {
    if (gs_arg_is_string(cs, 1)) {
      (gs_interface->handle_option)(gs_interface->app_params,
					option_code,
					muesli_malloc_copy_string(gs_string_arg(cs, 1)),
					0.0, 1,
					"gs");
    } else if (gs_arg_is_number(cs, 1)) {
      (gs_interface->handle_option)(gs_interface->app_params,
					option_code, NULL, gs_number_arg(cs, 2), 1,
					"gs");
    } else {
      (gs_interface->handle_option)(gs_interface->app_params,
					option_code, (char*)"true", 0.0, 1,
					"gs");
    }
  }
}

static void
gs_set_parameters(gs_state *cs)
{
  if (gs_count_args(cs) < 1)  {
    fprintf(stderr, "too few args to gs_set_parameters\n");
    gs_error(cs, (char*)"argcount", (char*)"set_parameters");
  }

#if 0
  // Fill in: use a table iterator from your language
  gs_table table = gs_table_arg(cs, 0);

  gs_table_iteration_start(cs, table);
  while (gs_table_iteration_next(cs, table) != 0) {
    gs_set_parameter(cs,
			 gs_table_iteration_current_key(cs, table),
			 gs_table_iteration_current_value(cs, table));
  }

#endif
}

static void
gs_get_parameter(gs_state *cs)
{
  if (gs_count_args(cs) < 1)  {
    fprintf(stderr, "too few args to gs_get_parameter\n");
    gs_error(cs, (char*)"argcount", (char*)"get_parameter");
  }

  char option_code = muesli_find_option_letter(gs_interface->getopt_options,
					       gs_string_arg(cs, 0));

  if (option_code != -1) {

muesli_value_t result = (gs_interface->handle_option)(gs_interface->app_params,
							  option_code,	// option
							  NULL, 0.0,	// value
							  0,	// set
							  "gs");

    switch (result.type) {
    case muesli_value_const_string:
      gs_return_string(cs, result.data.as_const_string);
      break;
    case muesli_value_float:
      gs_return_number(cs, result.data.as_float);
      break;
    case muesli_value_integer:
      gs_return_integer(cs, result.data.as_int);
      break;
    case muesli_value_boolean:
      gs_return_boolean(cs, result.data.as_int);
      break;
    default:
      gs_return_boolean(cs, 0);
      break;
    }
  }
}

static void
gs_get_parameters(gs_state *cs)
{
  gs_table *table = gs_create_table(cs, 48);

  // todo: fix and re-instate -- I have to get long_options across to it somehow
  struct option *option_names = gs_interface->getopt_options;

  while (option_names->name != 0) {
    
    muesli_value_t result = (gs_interface->handle_option)(gs_interface->app_params,
							      (option_names->val), // opt
							      NULL, 0.0, // value
							      0, // set
							      "gs");

    switch (result.type) {
    case muesli_value_const_string:
      gs_set_table_string(cs, table, (char*)(option_names->name), result.data.as_const_string);
      break;
    case muesli_value_float:
      gs_set_table_number(cs, table, (char*)(option_names->name), result.data.as_float);
      break;
    case muesli_value_boolean:
      gs_set_table_boolean(cs, table, (char*)(option_names->name), result.data.as_int);
      break;
    default:
      gs_set_table_boolean(cs, table, (char*)(option_names->name), 0);
      break;
    }
    option_names++;
  }
}
#endif

///////////////////////////////////////
// Call arbitrary evaluators by name //
///////////////////////////////////////

#if 0
static int
muesli_gs_eval_in_language(gs_state *cs)
{
  if (gs_count_args(cs) < 2) {
    fprintf(stderr, "too few args to gs_eval_in_language\n");
    gs_error(cs, (char*)"argcount", (char*)"eval_in_language");
    return 0;
  }

  if ((gs_arg_is_string(cs, 1)) && (gs_arg_is_string(cs, 2))) {
    const char *language_name = gs_string_arg(cs, 1);
    const char *evaluand = gs_string_arg(cs, 2);
    unsigned int evaluand_length = strlen(evaluand);

    fprintf(stderr, "In gs_eval_in_language(\"%s\", \"%s\")\n", language_name, evaluand);

    muesli_value_t result = muesli_eval_in_language(language_name,
						    evaluand,
						    evaluand_length,
						    ambient_transient);

    switch (result.type) {
    case muesli_value_float:
      gs_return_number(cs, result.data.as_float);
      break;
    case muesli_value_integer:
      gs_return_integer(cs, result.data.as_int);
      break;
    case muesli_value_const_string:
      gs_return_string(cs, result.data.as_const_string);
      break;
    case muesli_value_boolean:
      gs_return_boolean(cs, result.data.as_bool);
      break;
    case muesli_value_none:
    case muesli_value_error:
      gs_return_boolean(cs, 0);
      break;
    }
  } else {
    fprintf(stderr, "wrong type args to gs_eval_in_language\n");
    gs_error(cs, (char*)"argtype", (char*)"eval_in_language");
    return 0;
  }
  return 1;
}
#endif

///////////////////////////////
// Custom built-in functions //
///////////////////////////////

#if 0
static void
gs_eval_custom_function(gs_state *cs)
{
  if (gs_arg_is_string(cs, 0)) {
    char *string_arg = gs_string_arg(cs, 0);
    muesli_value_t result = (gs_interface->eval_string)(gs_interface,
							    string_arg, strlen(string_arg),
							    ambient_transient);
    switch (result.type) {
    case muesli_value_float:
      gs_return_number(cs, result.data.as_float);
      break;
    case muesli_value_integer:
      gs_return_integer(cs, result.data.as_int);
      break;
    case muesli_value_const_string:
      gs_return_string(cs, result.data.as_const_string);
      break;
    case muesli_value_boolean:
      gs_return_boolean(cs, result.data.as_int);
      break;
    case muesli_value_none:
    case muesli_value_error:
      gs_return_void(cs);
      break;
    }
  } else {
    fprintf(stderr, "gs_eval_function must be given a string\n");
    gs_error(cs, (char*)"argtype", (char*)"gs_eval");
  }
}
#endif

////////////////
// Initialize //
////////////////

void
gs_evaluator_init(evaluator_interface *interface)
{
  // Init gs interface

  // Fill in: initialize your gs application
#if 0
  gs_state *our_gs_state = gs_create_gs();
  interface->state = our_gs_state;
#endif
  gs_interface = interface;

  // Extend system

#if 0
  // Fill in: register all these language extensions (as applicable):
  if (muesli_extensions & MUESLI_EXTENSION_SINGLE_PARAMETER) {
    Muesli_Add_Fn_1(interface, (char*)"get_parameter", gs_get_parameter);
    Muesli_Add_Fn_2(interface, (char*)"set_parameter", gs_set_parameter);
  }
  if (muesli_extensions & MUESLI_EXTENSION_PARAMETER_BLOCK) {
    Muesli_Add_Fn_0(interface, (char*)"parameters", gs_get_parameters);
    Muesli_Add_Fn_1(interface, (char*)"modify_parameters", gs_set_parameters);
  }
  if (muesli_extensions & MUESLI_EXTENSION_EVAL_IN_LANGUAGE) {
    Muesli_Add_Fn_1(interface, (char*)"eval_in_language", muesli_gs_eval_in_language);
  }
  if (muesli_extensions & MUESLI_EXTENSION_CUSTOM) {
    Muesli_Add_Fn_1(interface, (char*)"custom", gs_eval_function);
  }
#endif

#if 0
  // Set up option names

  // Fill in: Create a table of option names.  You may well not need to bother.
  gs_table *option_names_table = gs_create_table(our_gs_state, 48);
  struct option *option_names;
  for (option_names = gs_interface->getopt_options;
       (option_names != NULL) && (option_names->name != 0);
       option_names++) {
    gs_set_table_number(our_gs_state, option_names_table,
			(char*)(option_names->name), (option_names->val));
  }
  gs_set_global_variable_table(our_gs_state,
			       gs_make_symbol(our_gs_state,
					      option_names_var_name),
			       option_names_table);
#endif
}

static void
gs_load_file(evaluator_interface *interface,
		const char *filename)
{
  int muesli_flags = interface->flags;
  Muesli_Enter_Evaluator(interface, 0);
  if (muesli_flags & TRACE_MUESLI_LOAD) {
    fprintf(stderr, "Loading %s\n", filename);
  }
  // Fill in: load the functions file given as (char*)(filename)
  if (muesli_flags & TRACE_MUESLI_LOAD) {
    fprintf(stderr, "Loaded %s\n", filename);
  }
  Muesli_Leave_Evaluator();
}

static muesli_value_t
gs_eval_string(evaluator_interface *evaluator,
		   const char *gs_c_string,
		   unsigned int string_length,
		   int transient)
{
  muesli_value_t result;
  Muesli_Enter_Evaluator(evaluator, transient);
  ANULL_VALUE(result);

  if (gs_c_string) {
    int old_ambient_transient = ambient_transient;
    ambient_transient = transient;
    // fprintf(stderr, "Gs evaluating string \"%s\"\n", gs_c_string);

    // Fill in: evaluate gs_c_string, decide what kind of result
    // it returns, and fill in the result pointer and the result type
    // accordingly.



    ambient_transient = old_ambient_transient;
  }
  Muesli_Leave_Evaluator();
  return result;
}

void
gs_setup(evaluator_interface *new_gs_interface)
{
  gs_interface = new_gs_interface;

  gs_interface->eval_string = gs_eval_string;
  gs_interface->load_file = gs_load_file;
#if 0
  gs_interface->version = GS_VERSION;
#endif
}

#endif
#endif

