/* muesli internal header file
   Copyright (C) 2008 - 2010 University of Limerick

   This file is part of muesli.
   
   muesli is free software: you can redistribute it and/or modify it under
   the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your
   option) any later version.
   
   muesli is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
   for more details.
   
   You should have received a copy of the GNU General Public License
   along with muesli.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MUESLI_INTERNAL_H
#define MUESLI_INTERNAL_H

/************/
/* The path */
/************/

extern void muesli_split_args(const char *string, const char *string0, char ***new_argv, int *new_argc);
extern unsigned int muesli_split_path();
extern char *muesli_find_executable(const char *basename);

extern char **path_array;
extern int n_pathelts;
extern int max_pathelt_len;

/*******************/
/* Bits and pieces */
/*******************/

extern char *muesli_malloc_copy_string(const char *original);
extern char *muesli_malloc_copy_string_n(const char *original, unsigned int length);

#define CLI_BUF_SIZE 1024

/*****************************/
/* Evaluator-specific things */
/*****************************/

/* The muesli-<language-name>.c files define these functions.

   The <language-name>_setup functions are NOT initialization
   functions for the associated interpreters; they just make some
   connections.  The interpreters get initialized by the *_init
   functions when they are asked for by name, i.e. in
   muesli_get_named_evaluator(string).

   Instead of modifying these functions to add your
   application-specific language extensions, you should use
   set_evaluator_app_specializer(string, specializer_function) to set
   a function to add your extensions.  This is called when the
   interpreter is initialized, which happens when you call
   get_named_evaluator, so you must call set_evaluator_app_specializer
   before then.

   The <language-name>_init functions are called when the evaluator
   concerned is initialized, typically as a result of finding it using
   muesli_get_named_evaluator.
*/

#ifdef HAVE_LIBECL
extern void ecl_setup(evaluator_interface*);
extern void ecl_evaluator_init(evaluator_interface *interface);
#endif
#ifdef HAVE_LIBELK
extern void elk_setup(evaluator_interface*);
extern void elk_evaluator_init(evaluator_interface *interface);
#endif
#ifdef HAVE_LIBERL_INTERFACE
extern void erlang_setup(evaluator_interface*);
extern void erlang_evaluator_init(evaluator_interface *interface);
#endif
#ifdef HAVE_LIBGS
extern void gs_setup(evaluator_interface*);
extern void gs_evaluator_init(evaluator_interface *interface);
#endif
#ifdef HAVE_LIBGUILE
extern void guile_setup(evaluator_interface*);
extern void guile_evaluator_init(evaluator_interface *interface);
#ifdef SCM_LIBGUILE_H
extern SCM muesli_to_guile(muesli_value_t muesli_value);
extern muesli_value_t guile_to_muesli(SCM guile_value);
#endif
#endif
#ifdef HAVE_LIBKSI
extern void ksi_setup(evaluator_interface*);
extern void ksi_evaluator_init(evaluator_interface *interface);
#endif
#ifdef HAVE_LIBLUA
extern void lua_setup(evaluator_interface*);
extern void lua_evaluator_init(evaluator_interface *interface);
#endif
#ifdef HAVE_LIBMOZJS
extern void javascript_setup(evaluator_interface*);
extern void javascript_evaluator_init(evaluator_interface *interface);
#ifdef jsapi_h___
typedef struct javascript_state {
  JSRuntime *rt;
  JSContext *cx;
  JSObject *global; 
} javascript_state;
extern JSBool muesli_to_javascript(JSContext *cx, muesli_value_t mval, jsval *rval);
extern void javascript_to_muesli(javascript_state *our_state, jsval *pval, muesli_value_t *presult);
#endif
#endif
#ifdef HAVE_LIBJVM
extern void jvm_setup(evaluator_interface*);
extern void jvm_evaluator_init(evaluator_interface *interface);
#endif
#ifdef HAVE_LIBMATHEVAL
extern void matheval_setup(evaluator_interface*);
extern void matheval_evaluator_init(evaluator_interface *interface);
#endif
#ifdef HAVE_LIBOCTINTERP
extern void octave_setup(evaluator_interface*);
extern void octave_evaluator_init(evaluator_interface *interface);
#endif
#ifdef HAVE_LIBPARROT
extern void parrot_setup(evaluator_interface*);
extern void parrot_evaluator_init(evaluator_interface *interface);
#endif
#ifdef HAVE_LIBPERL
extern void perl_setup(evaluator_interface*);
extern void perl_evaluator_init(evaluator_interface *interface);
#ifdef H_PERL
#define Muesli_Perl_Return(_mval_)                                  \
 { muesli_value_t rmval = (_mval_);                                 \
  switch (rmval.type) {                                             \
  case muesli_value_integer: XSRETURN_IV(rmval.data.as_int);        \
  case muesli_value_float: XSRETURN_NV(rmval.data.as_float);        \
  case muesli_value_malloced_string:                                \
  case muesli_value_const_string: XSRETURN_PV(rmval.data.as_const_string);      \
  case muesli_value_boolean:                                        \
    if (rmval.data.as_bool) { XSRETURN_YES; } else { XSRETURN_NO; } \
  case muesli_value_error: case muesli_value_none: XSRETURN_UNDEF;  \
  } }
#endif
#endif
#ifdef HAVE_LIBPL
extern void prolog_setup(evaluator_interface*);
extern void prolog_evaluator_init(evaluator_interface *interface);
#endif
#ifdef HAVE_LIBPYTHON
extern void python_setup(evaluator_interface*);
extern void python_evaluator_init(evaluator_interface *interface);
#ifdef Py_PYTHON_H
extern PyObject *muesli_to_python(muesli_value_t mv);
#endif
#endif
#ifdef HAVE_LIBR
extern void R_setup(evaluator_interface*);
extern void R_evaluator_init(evaluator_interface *interface);
#endif
#ifdef HAVE_LIBRUBY_STATIC
extern void ruby_setup(evaluator_interface*);
extern void ruby_evaluator_init(evaluator_interface *interface);
#endif
#if defined(HAVE_LIBSIOD) || defined(HAVE_LIBULSIOD)
extern void siod_setup(evaluator_interface*);
extern void siod_evaluator_init(evaluator_interface *interface);
#ifdef _ULSIOD_H_
extern siod_LISP muesli_to_siod(muesli_value_t mval);
#endif
#endif
#ifdef HAVE_LIBSLANG
extern void slang_setup(evaluator_interface*);
extern void slang_evaluator_init(evaluator_interface *interface);
#endif
#ifdef HAVE_LIBSYX
extern void syx_setup(evaluator_interface*);
extern void syx_evaluator_init(evaluator_interface *interface);
#endif
#ifdef HAVE_LIBTCC
extern void tcc_setup(evaluator_interface*);
extern void tcc_evaluator_init(evaluator_interface *interface);
#endif
#ifdef HAVE_LIBTCL
extern void tcl_setup(evaluator_interface*);
extern void tcl_evaluator_init(evaluator_interface *interface);
#ifdef _TCL
extern Tcl_Obj * muesli_to_tcl(muesli_value_t mval);
#endif
#endif

extern void machine_code_setup(evaluator_interface*);
extern void machine_code_evaluator_init(evaluator_interface *interface);

extern void stack_code_setup(evaluator_interface*);
extern void stack_bytecode_evaluator_init(evaluator_interface *interface);

extern void external_exec_setup(evaluator_interface*);
extern void exec_evaluator_init(evaluator_interface *interface);

extern void external_pipe_setup(evaluator_interface*);
extern void pipe_evaluator_init(evaluator_interface *interface);

extern void custom_setup(evaluator_interface*);
extern void custom_evaluator_init(evaluator_interface *interface);

extern void zero_setup(evaluator_interface*);
extern void zero_evaluator_init(evaluator_interface *interface);

#endif

/* muesli-internal.h ends here */
