;;; Guile bindings for Mutt
;;; Copyright (C) 2003  Ludovic Courts

;;; This program is free software; you can redistribute it and/or
;;; modify it under the terms of the GNU General Public License
;;; as published by the Free Software Foundation; either version 2
;;; of the License, or (at your option) any later version.
;;; 
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;; 
;;; You should have received a copy of the GNU General Public License
;;; along with this program; if not, write to the Free Software
;;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

(mutt-module (mutt aliases)
	     #:documentation
"This module redefines the @var{save-alias} function so that aliases
are written to files in a Schemey way.")

; Change the global definition for `save-alias' and use our own.
(define-aspect (save-alias alias filename)
  "Append a Scheme definition for @var{alias} to file @var{filename}."
  (let ((file (open-file filename "a")))
    (if file
      (and
	(format file "~s~%"
	  (list 'define-alias (alias-name alias)
	    (let* ((address (alias-address alias))
		   (personal (address-personal address))
		   (mailbox (address-mailbox address)))
	      (list 'create-address
		(string-append
		  (if personal (string-append personal " ") "")
		  (string-append "<" mailbox ">"))))))
	(close file)
	(ui-message "Alias added (Schemey way)."))
      #f)))
