/***************************************************************************
 * Author:             Manuele Vaggelli [manuele.vaggelli@member.fsf.org]
 * Creation_Date:      Tuesday, May 16, 2006
 * Last_Modified_Date: Friday, August 18, 2006
 * Program:            MySPwizard
 * File:               concat.c
 * Description:        Contains the function 'concat' for string concatenation
 * Note:               Version 1.0
 *
 * Copyright (C) 2006 Manuele Vaggelli
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc.,51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ***************************************************************************/

#include "concat.h"

char *
concat (const char *str, ...)
{
  va_list ap;
  size_t allocated = 100;
  char *result = (char *) malloc (allocated);
  char *wp;
  const char *s;
     
  if (allocated != 0)
    {
      char *newp;
     
      va_start (ap, str);
     
      wp = result;
      for (s = str; s != NULL; s = va_arg (ap, const char *))
	{
	  size_t len = strlen (s);
     
	  /* Resize the allocated memory if necessary.  */
	  if (wp + len + 1 > result + allocated)
	    {
	      allocated = (allocated + len) * 2;
	      newp = (char *) realloc (result, allocated);
	      if (newp == NULL)
		{
		  free (result);
		  return NULL;
		}
	      wp = newp + (wp - result);
	      result = newp;
	    }
     
	  wp = (char *)mempcpy (wp, s, len);
	}
     
      /* Terminate the result string.  */
      *wp++ = '\0';
     
      /* Resize memory to the optimal size.  */
      newp = realloc (result, wp - result);
      if (newp != NULL)
	result = newp;
     
      va_end (ap);
    }
     
  return result;
}
