package Test::mysql_sr_lib;

#    The MySQL General Purpose Stored Routines Library
#    Copyright (C) 2005 Giuseppe Maxia, Stardata s.r.l.
#    Contacts: http://www.stardata.it/contatti_en.html
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

use strict;
use warnings;
use English qw( -no_match_vars );
use base qw/ Exporter/;
use Test::More;
use DBI;
use DBD::mysql;

our @ISA        = qw(Exporter);
our @EXPORT_OK  = qw(test_connection get_result get_results do_query);
our @EXPORT     = @EXPORT_OK;

my $dbh;

sub test_connection
{
    my $expected_version = '3.0002_4';
    my ($HOST, $DB, $CONF, $how_many_tests) = @_;
    if ($DBD::mysql::VERSION lt $expected_version)
    {
        plan (skip_all => " -- MySQL DBD driver version not supported (expected $expected_version - got $DBD::mysql::VERSION)")
        
    }
    eval {
        $dbh =DBI->connect("dbi:mysql:$DB;host=$HOST"
            . ';mysql_server_prepare=1'
            . ";mysql_read_default_file=$CONF",
                undef,
                undef,
                { RaiseError => 1, PrintError => 0 }) 
         or die "Can't connect: $DBI::errstr\n"; 
    };
    if ($EVAL_ERROR) {
        plan (skip_all => ' -- no connection available')
    }
    else {
        plan( tests => $how_many_tests);
    }
    return $dbh;
}

sub get_results {
    my ( $query, @parameters) = @_;
    my $res;
    if (@parameters) {
        eval {
            $res = $dbh->selectall_arrayref($query, undef, @parameters);
        };
    }
    else {
       eval { $res = $dbh->selectall_arrayref($query) };
    }
    if ($EVAL_ERROR) {
        diag($EVAL_ERROR);
        return ;
    }
    return $res;
}

sub get_result {
    my ( $query, @parameters) = @_;
    my $res;
    if (@parameters) {
        eval {
            ($res) = $dbh->selectrow_array($query, undef, @parameters);
        };
    }
    else {
       eval { ($res) = $dbh->selectrow_array($query) };
    }
    if ($EVAL_ERROR) {
        diag($EVAL_ERROR);
        return ;
    }
    return $res;
}

sub do_query {
    my ($user_var, $query, @parameters) = @_;
    my $res;
    if (@parameters) {
       eval {$res = $dbh->do($query, undef, @parameters)};
    }
    else {
       eval { $res = $dbh->do($query)};
    }
    if ($EVAL_ERROR) {
        diag($EVAL_ERROR);
        return ;
    }
    if (defined $user_var) {
        return get_result(qq{select $user_var})
    }
    else {
        return $res;
    }
}

1;
