/*
# Copyright (C) 2008-2009 
# Raffaele Granito <raffaele.granito@tiscali.it>
#
# This file is part of myTCPClient:
# Universal TCP Client
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

 
/*
.--------------.
| headers LIBC |
'--------------' */
#include <stdio.h>
#include <sys/time.h>
#include <string.h>

/*
.--------------------.
| header Locale      |
'--------------------' */
#include "output.h"



/*
.----------------------------------------------------------.
|                                                          |
|  Funzione   : PrintMessage                               | 
|                                                          |
|  Descrizione: Visualizza un messaggio                    |
|                                                          |
'----------------------------------------------------------'*/
int PrintMessage (int debug_level, char *TABMSG[][3], char *IDMsg)
{
    int i = 0;

    /*
    .------------------------------------------------.
    | Quit, from debug level __NONE__                |
    '------------------------------------------------' */ 
    if (debug_level==0) 
        return 0; 

    while ( strcmp(TABMSG[i][0],"END") != 0 && strcmp(TABMSG[i][0],IDMsg) != 0 ) 
    { 
            i++; 
    };

    int message_debug_level = 0;
    if ( strcmp(TABMSG[i][1],"__NONE__")==0 ) { message_debug_level = 0; };
    if ( strcmp(TABMSG[i][1],"__INFO__")==0 ) { message_debug_level = 1; };
    if ( strcmp(TABMSG[i][1],"__WARN__")==0 ) { message_debug_level = 2; };
    if ( strcmp(TABMSG[i][1],"__ERR__" )==0 ) { message_debug_level = 3; };

    if ( debug_level <= message_debug_level )
    { 
         printf ("%s", TABMSG[i][2]);
         fflush(stdout);
    };

    return 0;
};


/*
.-----------------------------------------------------------------------------.
|                                                                             |
|  Funzione   : Dumps                                                         |
|                                                                             |
|  Descrizione: Dumps raw memory in hex byte and printable split format.      |
|               (written John Erikson)                                        |
|                                                                             |
|                                                                             |
|                                                                             |
|                                                                             |
|                                                                             |
'-----------------------------------------------------------------------------' */ 
void dump(const unsigned char *data_buffer, const unsigned int length) {
   unsigned char byte;
   unsigned int i, j;
   for(i=0; i < length; i++) {
      byte = data_buffer[i];
      printf("%02x ", data_buffer[i]); // Display byte in hex.
      if(((i%16)==15) || (i==length-1)) {
         for(j=0; j < 15-(i%16); j++)
            printf("   ");
         printf("| ");
         for(j=(i-(i%16)); j <= i; j++) { // Display printable bytes from line.
            byte = data_buffer[j];
            if((byte > 31) && (byte < 127)) // Outside printable char range
                printf("%c", byte);
            else
                printf(".");
         }
         printf("\n"); // End of the dump line (each line is 16 bytes)
      } // End if
   } // End for
};


/*
.-----------------------------------------------------------------------------.
|                                                                             |
|  Funzione   : GetDebugLevel                                                 |
|                                                                             |
|  Descrizione:                                                               |
|                                                                             |
|                                                                             |
|                                                                             |
|                                                                             |
|                                                                             |
|                                                                             |
'-----------------------------------------------------------------------------' */
int GetDebugLevel ( char *strDebug, char *protocollo )
{
    if ( strDebug == NULL )
         return __NONE__ ;

    if ( protocollo == NULL )
         return __NONE__ ;

    char *strDebugLevel ;

    strDebugLevel = malloc ( strlen(strDebug) + 5 );

    sprintf(strDebugLevel, "+++%s", protocollo);  if ( strstr(strDebug, strDebugLevel ) != NULL ) return __INFO__ ;
    sprintf(strDebugLevel,  "++%s", protocollo);  if ( strstr(strDebug, strDebugLevel ) != NULL ) return __WARN__ ; 
    sprintf(strDebugLevel,   "+%s", protocollo);  if ( strstr(strDebug, strDebugLevel ) != NULL ) return __ERR__  ; 

    return __NONE__ ;
};  



/*
.-----------------------------------------------------------------------------------------.
|                                                                                         |
|  Funzione   : Uri2SingleFieldConnect                                                    |
|                                                                                         |
|  Descrizione: Verifica la URI passata tramite il parametro --connect e restituisce      |
|               i singoli campi: protocollo, host, porta, percorso e risorsa.             |
|               Al momento i primi 3 parametri risultano abbligatori                      |
|                                                                                         |
|  Return Code:  -1 errore: Protocollo  * Non Specificato (len 0)                         | 
|                -2 errore: Protocollo  * Missing Separatore con Hostname (://)           | 
|                -3 errore: Hostname    * Non Specificato (len 0)                         | 
|                -4 errore: Porta       * Valore non numerico                             |
|                -5 errore: Porta       * Valore non valido ( ! 1..65535 )                | 
|                -6 errore: QueryString * Missing separatore URL/Query [?]                |              
|                -7 errore: QueryString * Missing QueryString (len 0)                     |              
|                -8 errore: QueryString * Lunga più di __DIM_QUERY_STRING__ caratteri     |
|                -9 errore: QueryString * Missing separatore variabile                    |              
|               -10 errore: QueryString * Missing variable (len 0)                        |               
|               -11 errore: QueryString * Missing carattere di assegnazione valore        |
|                                                                                         |
|  TODO       : Bisogna aggiungere il controllo sui caratteri validi per protocollo,      |
|               hostname e query string (alfabetici + soli caratteri consentiti...)       |
|                                                                                         |
|                                                                                         |
'-----------------------------------------------------------------------------------------'*/
extern struct tUri2SingleFieldConnect Uri2SingleFieldConnect(char uri[1024])
{

#define __DIM_QUERY_STRING__ 1024

       int indice_uri = 0;
       int indice = 0;

       char porta[1024];

       int DEBUG = 0;

       /*
       .-----------------------------------------------------------.
       | Dichiara la struttura di OUTPUT                           |
       '-----------------------------------------------------------' */
       struct tUri2SingleFieldConnect  rUri2SingleFieldConnect; 
       struct tUri2SingleFieldConnect *pUri2SingleFieldConnect; 

       /*
       .-----------------------------------------------------------.
       | Alloca spazio per la struttura di OUTPUT                  |
       '-----------------------------------------------------------' */
       pUri2SingleFieldConnect = &rUri2SingleFieldConnect;

       /*
       .-----------------------------------------------------------.
       | Inizializza la struttura di OUTPUT                        |
       '-----------------------------------------------------------' */
       memset((void*)&rUri2SingleFieldConnect,0,sizeof(rUri2SingleFieldConnect));
       rUri2SingleFieldConnect.return_code = 0;

       /*
       .-----------------------------------------------------------------------.
       | PASSO 1: Estrae il PROTOCOLLO e verifica esistenza (len > 0)          |
       +-----------------------------------------------------------------------+
       |                                                                       |
       |                                                                       |
       |                                                                       |
       |                                                                       |
       |                                                                       |
       |                                                                       |
       |                                                                       |
       |                                                                       |
       '-----------------------------------------------------------------------' */
       indice = 0;
       while ( uri[indice_uri] != 0 && uri[indice_uri] != ':' )
       {
               rUri2SingleFieldConnect.protocollo[indice] = uri[indice_uri];
               indice_uri++;
               indice++;
       }
       rUri2SingleFieldConnect.protocollo[indice] = 0;

       if ( strlen(rUri2SingleFieldConnect.protocollo) == 0 )
       {
            rUri2SingleFieldConnect.return_code = -1 ;
            return rUri2SingleFieldConnect;
       };

       /*
       .-----------------------------------------------------------------------.
       | PASSO 2: Verifica blocco di separazione protocollo|host               |
       +-----------------------------------------------------------------------+
       |                                                                       |
       |                                                                       |
       |                                                                       |
       |                                                                       |
       |                                                                       |
       |                                                                       |
       |                                                                       |
       |                                                                       |
       '-----------------------------------------------------------------------' */
       if (( uri[indice_uri]     == ':' &&
             uri[indice_uri + 1] == '/' &&
             uri[indice_uri + 2] == '/'))
       {
            indice_uri = indice_uri + 3 ;
       }
       else
       {
            rUri2SingleFieldConnect.return_code = -2 ;
            return rUri2SingleFieldConnect;
       };

       /*
       .-----------------------------------------------------------------------.
       | PASSO 2: Estrae l'HOSTNAME                                            |
       +-----------------------------------------------------------------------+ 
       | Legge fino ai due-punti oppure fine allo slash oppure se finisce il   |
       | buffer cioè se trova un zero-binario. Nel primo caso il carattere     |
       | riscontrato server per specificare la porta TCP/IP, nel secondo caso  |
       | un path per rintracciare una risorsa. L'hostname estratto poi         |
       | andrebbe verificato, una prima verifica è che non sia nullo, ad       |
       | esempio come nel caso seguente: http://:80, http://, http:///         |
       | andrebbero aggiunti altri controlli ad esempio che nel caso di nome   |
       | di dominio i caratteri che lo compongono siano validi.                |
       '-----------------------------------------------------------------------' */
       indice = 0;
       while ( uri[indice_uri] != 0 && uri[indice_uri] != ':' && uri[indice_uri] != '/' && uri[indice_uri] != '?' )
       {
               rUri2SingleFieldConnect.host[indice] = uri[indice_uri];
               indice_uri++;
               indice++;
       }
       rUri2SingleFieldConnect.host[indice] = 0;

       if ( strlen(rUri2SingleFieldConnect.host) == 0 )
       {
          rUri2SingleFieldConnect.return_code = -3 ;
          return rUri2SingleFieldConnect;
       };

       if ( uri[indice_uri] == ':' )
       {
            indice_uri = indice_uri + 1 ;
       }

       /*
       .-----------------------------------------------------------------------.
       | PASSO 3: Estrae la PORTA                                              |
       +-----------------------------------------------------------------------+
       |                                                                       |
       |                                                                       |
       |                                                                       |
       |                                                                       |
       |                                                                       |
       |                                                                       |
       |                                                                       |
       |                                                                       |
       '-----------------------------------------------------------------------' */
       rUri2SingleFieldConnect.porta = 0 ; 
       if ( uri[indice_uri-1] == ':' ) 
       {
            indice = 0;
            while ( uri[indice_uri] != 0 && uri[indice_uri] != '/' && uri[indice_uri] != '?' )
            {
                    porta[indice] = uri[indice_uri];
                    indice_uri++;
                    indice++;
            }
            porta[indice] = 0;
            if (!(rUri2SingleFieldConnect.porta=atoi(porta)))
            {
                    rUri2SingleFieldConnect.return_code = -4 ;
                    return rUri2SingleFieldConnect;
            };

            if ( rUri2SingleFieldConnect.porta < 1 || rUri2SingleFieldConnect.porta > 65635 ) 
            {
                    rUri2SingleFieldConnect.return_code = -5 ;
                    return rUri2SingleFieldConnect;
            };
       };

       /*
       .-----------------------------------------------------------------------.
       | PASSO 4: Estrae la PATH RISORSA + RISORSA                             |
       +-----------------------------------------------------------------------+
       | Legge e bufferizza fino a fine stringa o inizio query string, o       |
       | trova uno slash. In quel caso sbuferizza e considera path_risorsa     |
       | quanto letto fino a quel momento, anche path_risorsa viene            |
       | bufferizzata a sua volta perchè la path può essere a più livelli      |
       | (es. /dir1/dir2/...). Arrivati a fine stringa oppure al separatore    |
       | con query string il contenuto della bufferizzazione esterna viene     |
       | considerata risorsa.                                                  |
       |                                                                       |
       | esempio 1. /dir1/dir2/filename                                        |    
       |            ---------- --------                                        |
       |            path       risorsa                                         | 
       |                                                                       |
       '-----------------------------------------------------------------------' */
       char tmpbuf[1024];
       tmpbuf[0] = 0;  
       rUri2SingleFieldConnect.risorsa_path[0] = 0; 
       indice = 0;
       while ( uri[indice_uri] != 0 && uri[indice_uri] != '?' )
       {
               tmpbuf[indice] = uri[indice_uri];
               tmpbuf[indice+1] = 0; 
               indice++;

               if ( uri[indice_uri] == '/' )
               {
                    strcat (rUri2SingleFieldConnect.risorsa_path, tmpbuf);
                    indice = 0;
                    tmpbuf[indice] = 0;
               }

               indice_uri++;
       }
       strcpy(rUri2SingleFieldConnect.risorsa, tmpbuf) ; 

       /*
       .-----------------------------------------------------------------------.
       | PASSO 5: Estrae la QUERY STRING                                       |
       +-----------------------------------------------------------------------+
       | effettua il pharse della query string. Questa per essere valida :     |
       |                                                                       |
       | * non deve essere più lunga di 1Kb (1024 byte),                       | 
       | * deve essere nel formato variabile valore,                           |
       | * il separatore variabile valore è l'uguale (=)                       |
       | * il separatore di due coppie di variabile/valore è l'amperstand (&)  |
       | * il valore per una variabile può essere anche nullo                  |
       |                                                                       |
       | (per altre regole di conformità/validità è necessario approfondire,   |
       | Ad esempio non tutti i caratteri validi mi sembra, esistono delle     |
       | codifiche per rappresentare quelli non validi (tipo spazi, & etc...)  |                                                                      |
       | Non so ad esempio che succede se una variabile viene impostata più    |
       | di una volta...                                                       |
       |                                                                       |
       | Esempio di Query string valida : var1=100&var2=CASA&var3=&var4=1      |                                                                      |
       | Il blocco analizza la query string è popola una tabella variabile/    |
       | valore, quindi la quesry string di esempio andrà a popolare in questo |
       | modo la tabella di output :                                           | 
       |                                                                       |
       | Variabile     Valore                                                  |
       | ============= ======================                                  |
       | var1          100                                                     |
       | var2          CASA                                                    |
       | var3                                                                  |
       | var4          1                                                       |
       |                                                                       |
       | Il parse ha bisogno di una variabile di stato (parse_state) per       |
       | analizzare la query string, quello di seguito è il dominio di tutti i |
       | valori possibili :                                                    |
       |                                                                       |
       | 0 - Fine coppia o prima coppia. Attesa nuova variabile o fine         |
       |                                                                       |
       | 1 - Separatore Variabile/Valore (carattere di assegnazione: '=')      |
       |     Atteso nuova valore o separatore coppie nel caso il valore        |
       |     della variabile in analisi è nullo.                               |
       |                                                                       |
       | 2 - Separatore Coppie Variabile/Valore (carattere di separazione '&') | 
       |     Atteso nuova variabile.                                           |
       |                                                                       |
       | return_code :                                                         |
       |                                                                       |
       |  -6 errore: QueryString : Missing separatore URL/Query [?]            |                    
       |  -7 errore: QueryString : Missing QueryString (len 0)                 | 
       |  -8 errore: QueryString : Lunga più di __DIM_QUERY_STRING__ caratteri |
       |  -9 errore: QueryString : Missing separatore variabile                | 
       | -10 errore: QueryString : Missing variable (len 0)                    | 
       | -11 errore: QueryString : Missing carattere di assegnazione valore    | 
       |                                                                       |
       '-----------------------------------------------------------------------' */
       rUri2SingleFieldConnect.queryStringDimTabVariable = 0; 
       rUri2SingleFieldConnect.queryStringLen = 0;

       int parse_state = 0 ; 
       tmpbuf[0] = 0;
       indice = 0;

       /*
       .-----------------------------------------------------.
       | Se la URI non è terminata ma a fine URL non è stato |
       | trovato il carattere di separazione tra URL e Query |
       | String [?] allora è un errore. In caso contrario si |
       | incrementa il vettore di 1 per superare il          |
       | carattere di separazione.                           |
       '-----------------------------------------------------' */
       if ( uri[indice_uri]   != 0 && uri[indice_uri] != '?' )
       {
            rUri2SingleFieldConnect.return_code = -6 ;
            goto Uri2SingleFieldConnect_end ;
       };

       if ( uri[indice_uri+1] == 0 && uri[indice_uri] == '?' )
       {
            rUri2SingleFieldConnect.return_code = -7 ;
            goto Uri2SingleFieldConnect_end ;
       };

       indice_uri++;
 
       while ( uri[indice_uri] != 0 )
       {
               /*
               .----------------------------------------------------------.
               | -= ERR =- La QueryString non può essere maggiore di 1024 |
               '----------------------------------------------------------' */
               rUri2SingleFieldConnect.queryStringLen++;
               if ( rUri2SingleFieldConnect.queryStringLen > __DIM_QUERY_STRING__ )
               {
                    rUri2SingleFieldConnect.return_code = -8 ;
                    goto Uri2SingleFieldConnect_end ;
               };

               /*
               .----------------------------------------.
               | Lettura in corso di variabile o valore |
               '----------------------------------------' */
               if ( uri[indice_uri] != '=' && uri[indice_uri] != '&' )
               {
                    tmpbuf[indice] = uri[indice_uri];
                    tmpbuf[indice+1] = 0;
                    indice++;
               }; 
 
               /*
               .-----------------------------.
               | carattere di assegnazione   |
               '-----------------------------' */ 
               if ( uri[indice_uri] == '=' )
               {
                    /*
                    .-----------------------------------------------------.
                    | -= ERR =- Missing & o doppio =                      |
                    +-----------------------------------------------------+
                    | Se è stato trovato il carattere di assegnazione ma  |
                    | è in corso la lettura di un valore (state=1)        |
                    | es. var1=asd=, var1==  significa che potrebbe       |
                    | mancare un carattere di separazione variabili (&)   |
                    | oppure è stato inserito 2 volte il carattere di     |
                    | assegnazione.                                       |
                    '-----------------------------------------------------' */ 
                    if ( parse_state == 1 ) 
                    {    
                         rUri2SingleFieldConnect.return_code = -9 ;
                         goto Uri2SingleFieldConnect_end ;
                    };

                    /*
                    .-----------------------------------------------------.
                    | -= ERR =- Missing Variable                          |   
                    +-----------------------------------------------------+
                    | Se è stato trovato il carattere di assegnazione ma  | 
                    | la variabile non è ancora stata definita            |
                    | e. "var1=100&=", "=" è un errore.                   | 
                    |                                                     |
                    |                                                     |
                    |                                                     |
                    '-----------------------------------------------------' */ 
                    if ( strlen(tmpbuf) == 0 )
                    {
                         rUri2SingleFieldConnect.return_code = -10 ;
                         goto Uri2SingleFieldConnect_end ;
                    };
                 
                    /*
                    .---------------------------------.
                    | found variable->name            |
                    '---------------------------------' */
                    rUri2SingleFieldConnect.queryStringTabVariable[rUri2SingleFieldConnect.queryStringDimTabVariable].variable = malloc(strlen(tmpbuf)+1) ;
                    strcpy(rUri2SingleFieldConnect.queryStringTabVariable[rUri2SingleFieldConnect.queryStringDimTabVariable].variable, tmpbuf) ; 
                    
                    indice         = 0 ;
                    tmpbuf[indice] = 0 ;
                    parse_state    = 1 ;
               }
     
               /*
               .--------------------------. 
               | delimitatore fine valore |
               '--------------------------' */ 
               if ( uri[indice_uri] == '&' )
               {
                    /*
                    .-----------------------------------------------------.
                    | -= ERR =- Missing = o doppio &                      |
                    +-----------------------------------------------------+
                    | Se è stato trovato il carattere di assegnazione ma  |
                    | la variabile non è completamente definita           |
                    | es. "var1&", "&", "&&" è un errore.                 |
                    | La variabile può essere nulla (es. var=&) quindi    |
                    | la casistica è da ritenersi valida.                 |
                    '-----------------------------------------------------' */
                    if ( parse_state == 0 ) 
                    {
                         rUri2SingleFieldConnect.return_code = -11 ;
                         goto Uri2SingleFieldConnect_end ;
                    };

                    /*
                    .---------------------------------.
                    | found variable->value           |
                    '---------------------------------' */ 
                    rUri2SingleFieldConnect.queryStringTabVariable[rUri2SingleFieldConnect.queryStringDimTabVariable].value = malloc(strlen(tmpbuf)+1) ;
                    strcpy(rUri2SingleFieldConnect.queryStringTabVariable[rUri2SingleFieldConnect.queryStringDimTabVariable].value, tmpbuf) ; 

                    indice         = 0 ;
                    tmpbuf[indice] = 0 ;
                    parse_state    = 0 ;

                    rUri2SingleFieldConnect.queryStringDimTabVariable++;
               }
               indice_uri++;
       }

       if ( rUri2SingleFieldConnect.queryStringLen > 0 )
       {
            if ( parse_state == 0 ) 
            {    
                 /*
                 .-----------------------------------------------------.
                 | -= ERR =- Missing & o doppio =                      |
                 +-----------------------------------------------------+
                 | Se è stato trovato il carattere di assegnazione ma  |
                 | è in corso la lettura di un valore (state=1)        |
                 | es. var1=asd=, var1==  significa che potrebbe       |
                 | mancare un carattere di separazione variabili (&)   |
                 | oppure è stato inserito 2 volte il carattere di     |
                 | assegnazione.                                       |
                 '-----------------------------------------------------' */
                 if ( strlen(tmpbuf) == 0 ) 
                 {
                      rUri2SingleFieldConnect.return_code = -9 ;
                 }

                 /*
                 .-----------------------------------------------------.
                 | -= ERR =- Missing Variable                          |
                 +-----------------------------------------------------+
                 | Se è stato trovato il carattere di assegnazione ma  |
                 | la variabile non è ancora stata definita            |
                 | e. "var1=100&=", "=" è un errore.                   |
                 |                                                     |
                 |                                                     |
                 |                                                     |
                 '-----------------------------------------------------' */
                 if ( strlen(tmpbuf) > 0 )
                 {  
                      rUri2SingleFieldConnect.return_code = -10 ;
                 };

                 goto Uri2SingleFieldConnect_end ; 
            };

            /*
            .---------------------------------.
            | found variable->value           |
            '---------------------------------' */
            rUri2SingleFieldConnect.queryStringTabVariable[rUri2SingleFieldConnect.queryStringDimTabVariable].value = malloc(strlen(tmpbuf)+1) ;
            strcpy(rUri2SingleFieldConnect.queryStringTabVariable[rUri2SingleFieldConnect.queryStringDimTabVariable].value, tmpbuf) ;

            rUri2SingleFieldConnect.queryStringDimTabVariable++;
       };
     
 
Uri2SingleFieldConnect_end: 

       /*
       .---------------------------------------------------------------.
       | Visualizza risultato del parse sull'URI letta.                |
       |                                                               |
       |                                                               |
       |                                                               |
       |                                                               |
       '---------------------------------------------------------------' */
       if ( DEBUG == 1 )
       {
            printf ("\n.-----------------------------------------------------------------------------.");
            printf ("\n|                Funzione Uri2SingleFieldConnect DUMP DEBUG                   |");
            printf ("\n'-----------------------------------------------------------------------------'\n\n");

            printf ("\nX------------------------- Valori di Input -----------------------------------X\n\n");

            printf ("\nuri                  : [%s]\n\n" , uri         );


            printf ("\nX------------------------- Valori di Output ----------------------------------X\n\n");

            printf("\nprotocollo            : [%s]", rUri2SingleFieldConnect.protocollo                ); 
            printf("\nhost                  : [%s]", rUri2SingleFieldConnect.host                      ); 
            printf("\nporta                 : [%d]", rUri2SingleFieldConnect.porta                     ); 
            printf("\npath                  : [%s]", rUri2SingleFieldConnect.risorsa_path              ); 
            printf("\nrisorsa               : [%s]", rUri2SingleFieldConnect.risorsa                   );
            printf("\nLunghezza QueryString : [%d]", rUri2SingleFieldConnect.queryStringLen            ); 
            printf("\nNumero Variabili      : [%d]", rUri2SingleFieldConnect.queryStringDimTabVariable ); 
            printf("\nreturn-code           : [%d]", rUri2SingleFieldConnect.return_code               );
            printf("\n");

            int indice = 0 ;
            while ( indice < rUri2SingleFieldConnect.queryStringDimTabVariable )
            {
                    printf ("\n[%3d.]  [%30s] = [%30s]", 
                            indice, 
                            rUri2SingleFieldConnect.queryStringTabVariable[indice].variable, 
                            rUri2SingleFieldConnect.queryStringTabVariable[indice].value ); 

                    indice++;
            }
            printf("\n");
       };

       return rUri2SingleFieldConnect ;
};


