/*
# Copyright (C) 2008-2009 
# Raffaele Granito <raffaele.granito@tiscali.it>
#
# This file is part of myTCPClient:
# Universal TCP Client
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

/*
.--------------.
| headers LIBC |
'--------------' */
#include <stdlib.h>
#include <string.h>

/*
.----------------------------.
| header Generic Client      |
'----------------------------' */
#include "common.h"

/*
.--------------------.
| header myTCPClient |
'--------------------' */
#include "myTCPClient.h" 
#include "param.h"



int main(int argc, char **argv)
{

    /*
    .------------------------------------------.
    | Dichiarazione delle STRUTTURE            |
    '------------------------------------------' */
    struct tParametriCheck  rParametriCheck;
    struct tParametriCheck *pParametriCheck;

    struct tClientConnect   rClientConnect; 
    struct tClientConnect  *pClientConnect;

    /*
    .--------------------------------------------------.
    | Alloca lo spazio per contenere la struttura dati |
    | che va a riempire la funzione ClientConnect. La  |
    | seconda istruzione serve per dedicare lo spazio  |
    | allocato alla struttura dati. Successivamente    |
    | inizializza l'intera struttura con NULL ed il    |
    | campo return_code a ZERO.                        |
    '--------------------------------------------------' */
    pParametriCheck = malloc(sizeof(struct tParametriCheck));
    pParametriCheck = &rParametriCheck;
    memset((void*)&rParametriCheck,0,sizeof(rParametriCheck));
    rParametriCheck.return_code = 0;

    pClientConnect = malloc(sizeof(struct tClientConnect));
    pClientConnect = &rClientConnect;
    memset((void*)&rClientConnect,0,sizeof(rClientConnect));
    rClientConnect.return_code = 0;

    /*
    .--------------------------------------------------.
    | Verifica i parametri passati                     |
    '--------------------------------------------------' */
    rParametriCheck = ParametriCheck(argc, argv, "myTCPClient", "0.0.5" );
    if (rParametriCheck.return_code != 0)
        exit(0);

    /*
    .-------------------------------.
    | Connection to server          |
    '-------------------------------' */
    rClientConnect =
         ClientConnect ( rParametriCheck.rClientConnectParameter ); 

    exit (0);
};     




