#! /bin/bash

# This file is part of Named Constant Generator (GenNC).
#
# Named Constant Generator (GenNC) is free software: you can
# redistribute it and/or modify it under the terms of the GNU General
# Public License as published by the Free Software Foundation, either
# version 3 of the License, or (at your option) any later version.
# 
# Named Constant Generator (GenNC) is distributed in the hope that it
# will be useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Named Constant Generator (GenNC).  If not, see
# <http://www.gnu.org/licenses/>.
# 
# Diese Datei ist Teil von Named Constant Generator (GenNC).
# 
# Named Constant Generator (GenNC) ist Freie Software: Sie knnen es
# unter den Bedingungen der GNU General Public License, wie von der
# Free Software Foundation, Version 3 der Lizenz oder (nach Ihrer
# Wahl) jeder spteren verffentlichten Version, weiterverbreiten
# und/oder modifizieren.
# 
# Named Constant Generator (GenNC) wird in der Hoffnung, dass es
# ntzlich sein wird, aber OHNE JEDE GEWHELEISTUNG, bereitgestellt;
# sogar ohne die implizite Gewhrleistung der MARKTFHIGKEIT oder
# EIGNUNG FR EINEN BESTIMMTEN ZWECK.  Siehe die GNU General Public
# License fr weitere Details.
# 
# Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
# Programm erhalten haben. Wenn nicht, siehe <http://www.gnu.org/licenses/>.
#
# Copyright (C) 2009,2010,2011,2013 Johannes Willkomm 

if [[ -z "$GENNC_HOME" ]]; then
    GENNC_HOME=/usr
fi

GENNC_XSL=$GENNC_HOME/share/named-constant/xsl

optstring="vhcDCfslin:-:"
option=""

result=0

cMode=0
classMode=1
ostreamOps=1
className=Foo
inClass=0

listConstants=""

while getopts $optstring option; do
#    echo "option: $option"
    case $option in
        (\?)
        echo "gennc: error: illegal option $argv[$OPTIND] specified, aborting";
        exit 1
        ;;
        (h)
        showHelp="yes"
        ;;
        (v)
        showVersion="yes"
        ;;
        (-)
        opt=$OPTARG
        case $opt in
            (help)
                showHelp="yes"
                ;;
            (version)
                showVersion="yes"
                ;;
        esac
        ;;
        (f)
        classMode=0
        ;;
        (n)
        className=$OPTARG
        ;;
        (i)
        inClass=1
        ;;
        (c)
        classMode=1
        ;;
        (C)
        cMode=1
        ;;
        (s)
        ostreamOps=0
        ;;
        (l)
        listConstants=1
        ;;
        (D)
        debug=1
        set -x
        ;;
    esac
done

infile="${!OPTIND}"

if [[ -n "$showVersion" ]]; then
    str='$Id: gennc.sh 25 2013-11-07 18:50:51Z jwillkomm $'
    echo "${str:14:4}"
    exit
fi
if [[ -n "$showHelp" || -z "$infile" ]]; then
    echo "Usage: $0 [option] <input-XML>"
#    echo ""
    echo "Generate C/C++ enums from XML definition."
    echo ""
    echo " -h, --help           show help"
    echo " -v, --version        show version"
    echo " -D                   turn debugging on"
    echo " -c                   class mode (functions are )"
    echo " -n <name>            class mode: class name "
    echo "                        function are assumed to be in class <name>, necessary when -s is not given"
    echo " -i                   class mode: enum is inside the class given by -n"
    echo " -s                   class mode: no ostream operators"
    echo " -f                   function mode"
    echo " -l                   list constants defined in XML on stdout"
    echo ""
    echo "Example: $0 $GENNC_HOME/share/doc/named-constant/example.ncd.xml"
    echo ""
    echo "Report gennc bugs to johannes.willkomm@rwth-aachen.de."
#    echo "Visit the gennc homepage at: http://.../"
    exit
fi

if [[ -n "$listConstants" ]]; then
    xsltproc $GENNC_XSL/listnc.xsl $infile
    exit
fi

echo "xsltproc --param class-mode \"$classMode\" --param c-mode \"$cMode\"  --param ostream-operators \"$ostreamOps\" --param input-file-name \"'$infile'\" --param file-name \"'$(basename $infile .xml)'\" --param class-name \"$className\" --param in-class \"$inClass\" $GENNC_XSL/gennc.xsl $infile"
xsltproc --param class-mode "'$classMode'" --param c-mode "'$cMode'"  --param ostream-operators "'$ostreamOps'" --param input-file-name "'$infile'" --param file-name "'$(basename $infile .xml)'" --param class-name "'$className'" --param in-class "'$inClass'" $GENNC_XSL/gennc.xsl $infile
