% RES = GENNC_GET_NAME(GENNC, VAL)
%
% Look up in GENNC the name the constant with value VAL and return as
% RES. VAL is the integer value assigned to the constant.
%
% GENNC is the structure returned by the CREATEXYZ function, which is
% generated from the named constant XML definition file in which
% ncdef/@name is set to XYZ.
%
% If NAME is not found in GENNC return the empty string.
%
% Copyright (C) 2015 Johannes Willkomm
function res = gennc_get_name(gennc, val)
  fn = sprintf('x%d', val);
  res = '';
  if isfield(gennc.names_index, fn)
    res = gennc.names_index.(fn);
  end
% $Id: gennc_get_name.m 49 2015-04-08 10:00:53Z jwillkomm $
