////
// Test script for JavaScript Named Constant Generator (GENNC)
// Copyright (C) 2015 Johannes Willkomm 

function importObject(obj, target) {
    for (k in obj) {
        target[k] = obj[k]
    }
}

// require the generated script which creates the ENUM structure
var ENUM = {}
ENUM.ManagedEnum = require('./managedenum.ncd.js')

// import the constant and function names in the global namespace
importObject(ENUM.ManagedEnum, global)

// print all entries with their names and values
for (k = 0; k < getNumManagedEnum(); ++k) {
    var val = getManagedEnum(k)
    var name = getManagedEnumName(val)
    console.log('Enum value number %d has name "%s" and value %d',
                k, name, val);
}
