<?xml version="1.0" encoding="utf-8"?>
<!-- 
This XSL lists the named constants.
Example: xsltproc listnc.xsl example.ncd.xml

This file is part of Named Constant Generator.
Copyright © 2011 Johannes Willkomm 
See the file gennc for copying conditions.
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

  <xsl:output method="text"/>

  <xsl:template match="/">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="ncdef">
    <xsl:for-each select="c">
      <xsl:value-of select="@name"/>
      <xsl:choose>
        <xsl:when test="count(@val)">
          <xsl:text>=</xsl:text>
          <xsl:value-of select="@val"/>
        </xsl:when>
        <xsl:when test="count(expr)">
          <xsl:text>=</xsl:text>
          <xsl:apply-templates select="expr"/>
        </xsl:when>
      </xsl:choose>
      <xsl:text>&#9;-&#9;</xsl:text>
      <xsl:value-of select="."/>
      <xsl:text>&#xa;</xsl:text>
    </xsl:for-each>
  </xsl:template>

</xsl:stylesheet>
<!-- $Id: listnc.xsl 25 2013-11-07 18:50:51Z jwillkomm $ -->
