<?xml version="1.0" encoding="utf-8"?>
<!-- 
This file is part of Named Constant Generator.
Copyright © 2009,2010,2011,2012,2013 Johannes Willkomm 
See the file gennc for copying conditions.
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

  <xsl:output method="xml"/>

  <xsl:param name="file-name" select="/*/@name"/>
  <xsl:param name="input-file-name"/>
  <xsl:param name="class-name" select="'Foo'"/>
  <xsl:param name="strcmp-func" select="'strcasecmp'"/>

  <xsl:template match="/">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="@*|node()">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
  </xsl:template>
  
  <xsl:template match="ncdef/c" mode="gen-value">
    <xsl:choose>
      <xsl:when test="@val">
        <xsl:value-of select="@val"/>
      </xsl:when>
      <xsl:when test="preceding-sibling::c">
        <xsl:variable name="pres">
          <xsl:apply-templates select="preceding-sibling::c[1]" mode="gen-value"/>
        </xsl:variable>
        <xsl:value-of select="$pres + 1"/>
      </xsl:when>
      <xsl:otherwise>0</xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template match="ncdef/c">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:attribute name="val">
        <xsl:apply-templates select="." mode="gen-value"/>
      </xsl:attribute>
      <xsl:apply-templates select="node()"/>
    </xsl:copy>
  </xsl:template>

</xsl:stylesheet>
<!-- $Id: patch-gennc-gen-value.xsl 49 2015-04-08 10:00:53Z jwillkomm $ -->
