%%
% Test script for Matlab Named Constant Generator (GENNC)
% Copyright (C) 2015 Johannes Willkomm 

%%
% add directory with helper functions to path
addpath([getenv('GENNC_HOME') '/share/named-constant/matlab'])

%%
% run the generated function which creates the ENUM structure
gennc = createManagedEnum();

%%
% print all entries with their names and values
fns = fieldnames(gennc.index);
for i=1:length(fns)
  val = gennc.index.(fns{i});
  assert(val == gennc_lookup(gennc, fns{i}))
  assert(strcmp(gennc_get_name(gennc, val), fns{i}))
  fprintf(1, 'Enum value number %d has name "%s" and value %d\n',...
          i-1, gennc_get_name(gennc, val), gennc.index.(fns{i}));
end
