% RES = GENNC_LOOKUP(GENNC, NAME)
%
% Look up in GENNC the value of the constant named NAME and return as
% RES. Lookup is case-insensitive and NAME may be prefixed with the
% prefix in GENNC.prefix.
%
% GENNC is the structure returned by the CREATEXYZ function, which is
% generated from the named constant XML definition file in which
% ncdef/@name is set to XYZ.
%
% If NAME is not found in GENNC return NAN.
%
% Copyright (C) 2015 Johannes Willkomm
function res = gennc_lookup(gennc, name)
  res = nan();
  pname = name(length(gennc.prefix)+1:end);
  lname = tolower(name);
  lpname = tolower(pname);
  if isfield(gennc.index, name)
    res = gennc.index.(name);
  elseif isfield(gennc.index, pname)
    res = gennc.index.(pname);
  elseif isfield(gennc.lower_index, lname)
    res = gennc.lower_index.(lname);
  elseif isfield(gennc.lower_index, lpname)
    res = gennc.lower_index.(lpname);
  end
% $Id: gennc_lookup.m 49 2015-04-08 10:00:53Z jwillkomm $
