<?xml version="1.0" encoding="utf-8"?>
<!-- 
This file is part of Named Constant Generator.
Copyright © 2009,2010,2011,2012,2013,2015 Johannes Willkomm 
See the file gennc for copying conditions.
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

  <xsl:output method="text"/>

  <xsl:param name="min" select="'abcdefghijklmnopqrstuvwxyz'"/>
  <xsl:param name="maj" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'"/>

  <xsl:template match="/">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template name="file-header">
    <xsl:text>%%&#xa;</xsl:text>
    <xsl:text>% This file has been automatically generated by &#xa;</xsl:text>
    <xsl:text>% gennc.sh $Id: gennc-mat.xsl 50 2015-04-08 12:45:49Z jwillkomm $ &#xa;</xsl:text>
    <xsl:text>% from definition file </xsl:text>
    <xsl:value-of select="$input-file-name"/>
    <xsl:text>.&#xa;</xsl:text>
  </xsl:template>

  <xsl:template match="ncdef">
    <xsl:document href="create{@name}.m" method="text"  encoding="us-ascii">
      <xsl:text>% -*- matlab -*- &#xa;</xsl:text>
      <xsl:call-template name="file-header"/>
      <xsl:apply-templates select="." mode="gen-js"/>
      <xsl:text>&#xa;</xsl:text>
    </xsl:document>
  </xsl:template>

  <xsl:template match="text()" mode="gen-js"/>

  <xsl:template match="ncdef" mode="gen-js">function res = create<xsl:value-of select="@name"/>()
  res.prefix = '<xsl:value-of select="/*/@c-prefix"/>';
  res.index = struct(<xsl:for-each select="c">'<xsl:value-of
                select="@name"/>',<xsl:value-of select="@val"/><xsl:if test="position() != last()">, </xsl:if></xsl:for-each>);
  res.lower_index = struct(<xsl:for-each select="c">'<xsl:value-of
                select="translate(@name, $maj, $min)"/>',<xsl:value-of select="@val"/><xsl:if test="position() != last()">, </xsl:if></xsl:for-each>);
  res.names_index = struct(<xsl:for-each select="c">'x<xsl:value-of
                select="@val"/>','<xsl:value-of select="@name"/>'<xsl:if test="position() != last()">, </xsl:if></xsl:for-each>);
  res.comments = struct(<xsl:for-each select="c">'<xsl:value-of
                select="@name"/>','<xsl:value-of select="comment"/>'<xsl:if test="position() != last()">, </xsl:if></xsl:for-each>);
  </xsl:template>

</xsl:stylesheet>
<!-- $Id: gennc-mat.xsl 50 2015-04-08 12:45:49Z jwillkomm $ -->
