////
// Test script for JavaScript Named Constant Generator (GENNC)
// Copyright (C) 2015 Johannes Willkomm 

assert = require('assert')

function importObject(obj, target) {
    for (k in obj) {
        target[k] = obj[k]
    }
}

var ENUM = require('./managedenum.ncd.js')

// when we import the constant and function names in the global
// namespace, we can even use the constant and function names just as
// in C/C++: CONSTANT_A, etc.
importObject(ENUM, global)

// print all entries with their names and values
for (k = 0; k < ENUM.ManagedEnum.getNum(); ++k) {
    var val = ENUM.ManagedEnum.get(k)
    var name = ENUM.ManagedEnum.getName(val)
    console.log('Enum value number %d has name "%s" and value %d',
                k, name, val);
    assert(val == ENUM.ManagedEnum.getValue(name))
    assert(val == ENUM.ManagedEnum.getValue(name.toLowerCase()))
    assert(val == ENUM.ManagedEnum.index[name])
    assert(val == ENUM.ManagedEnum[ENUM.ManagedEnum.prefix + name])
    assert(name == ENUM.ManagedEnum.names_index[val])
}
