/*
 * timetrial.c - measure the execution time of DI(..), ...
 * 
 * Note: this isn't a serious benchmark since it occasionally comes up with
 *   -ve times. It also repeatedly executes a single breakpoint rather
 *   than exercising a series of them (each time a new breakpoint is hit
 *   the debugger seems to spend a lot of time thinking). All of this
 *   will have to await better measurements and some profiling of gdb.
 *
 * Copyright (c) 1997 Phil Maker
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: timetrial.c,v 1.1 1997/05/10 15:12:27 pjm Exp $
 */

#include <stdio.h>

#include "../src/now.h"

#include "DI.h"
#include "I.h"
#include "DL.h"
#include "L.h"
#include "Q.h"

#ifndef NT
#define NT 1000000 /* number of trials */
#endif

#ifndef DNT
#define DNT 1000 /* number of trials */
#endif

volatile int g;

volatile int a[100];

main() {
  int i;
  double t;
  double overhead;

  printf("* Time trial test %d %d\n", NT, DNT);

  /* Overhead */
  now_reset();
  for(i = 0; i != NT; i++) {
    g = i;
  }
  overhead = now();
  printf("loop overhead = %lfs \n", overhead);

  /* I */
  now_reset();
  for(i = 0; i != NT; i++) {
    I(g >= -1);
    g = i;
  }
  t = now();
  printf("I(g >= -1) takes %lfus/call\n", ((t - overhead)/NT)*1.0e6);

  /* I(A(...)) */
  now_reset();
  for(i = 0; i != NT; i++) {
    I(A(int x = 0, x != 100, x++, a[x] == 0));
    g = i;
  }
  t = now();
  printf("I(A(int x = 0, x != 100, x++, a[x] == 0)) takes %lfus/call\n", 
	 ((t - overhead)/NT)*1.0e6);

  /* DI */
  now_reset();
  for(i = 0; i != DNT; i++) {
    DI(g >= -1);
    g = i;
  }
  t = now();
  printf("DI(g >= -1) takes %lfms/call\n", ((t - overhead)/DNT)*1.0e3);

  /* DL */
  now_reset();
  for(i = 0; i != DNT; i++) {
    g = i;
    DL("mesg\n");
    g = i;
  }
  t = now();
  printf("DL(\"oops\\n\") takes %lfms/call\n", ((t - overhead)/DNT)*1.0e3);

  return 0;
}

  
